/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils {
    public static long fixLength(long value, int length) {
        int len = (int)Math.log10(value) + 1;
        int digDiff = length - len;
        if (digDiff > 0) {
            value = (long)((double)value * Math.pow(10.0, digDiff));
        } else if (digDiff < 0) {
            value = (long)((double)value / Math.pow(10.0, Math.abs(digDiff)));
        }
        return value;
    }

    public static int numberOfPlace(Number number) {
        if (NumberUtils.isIntNumber(number)) {
            return 0;
        }
        BigDecimal decimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(String.valueOf(number));
        String str = decimal.stripTrailingZeros().toPlainString();
        int index = str.indexOf(".");
        return index < 0 ? 0 : str.length() - index - 1;
    }

    public static boolean isIntNumber(Number number) {
        return number instanceof Integer || number instanceof Long || number instanceof Byte || number instanceof Short || number instanceof BigInteger;
    }
}

