/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.demo.protocol.DemoTopicMessageCodec;
import reactor.core.publisher.Mono;

public class DemoDeviceMessageCodec
extends DemoTopicMessageCodec
implements DeviceMessageCodec {
    public Transport getSupportTransport() {
        return DefaultTransport.MQTT;
    }

    public Mono<? extends Message> decode(MessageDecodeContext context) {
        return Mono.fromSupplier(() -> {
            MqttMessage mqttMessage = (MqttMessage)context.getMessage();
            String topic = mqttMessage.getTopic();
            JSONObject payload = JSON.parseObject((String)mqttMessage.getPayload().toString(StandardCharsets.UTF_8));
            return this.doEncode(topic, payload);
        });
    }

    public Mono<EncodedMessage> encode(MessageEncodeContext context) {
        Message message = context.getMessage();
        return Mono.fromSupplier(() -> {
            if (message instanceof ReadPropertyMessage) {
                String topic = "/read-property";
                JSONObject mqttData = new JSONObject();
                mqttData.put("messageId", (Object)message.getMessageId());
                mqttData.put("deviceId", (Object)((ReadPropertyMessage)message).getDeviceId());
                mqttData.put("properties", (Object)((ReadPropertyMessage)message).getProperties());
                return SimpleMqttMessage.builder().topic(topic).payload(Unpooled.copiedBuffer((byte[])JSON.toJSONBytes((Object)mqttData, (SerializerFeature[])new SerializerFeature[0]))).build();
            }
            if (message instanceof WritePropertyMessage) {
                String topic = "/write-property";
                JSONObject mqttData = new JSONObject();
                mqttData.put("messageId", (Object)message.getMessageId());
                mqttData.put("deviceId", (Object)((WritePropertyMessage)message).getDeviceId());
                mqttData.put("properties", (Object)((WritePropertyMessage)message).getProperties());
                return SimpleMqttMessage.builder().topic(topic).payload(Unpooled.copiedBuffer((byte[])JSON.toJSONBytes((Object)mqttData, (SerializerFeature[])new SerializerFeature[0]))).build();
            }
            if (message instanceof FunctionInvokeMessage) {
                String topic = "/invoke-function";
                FunctionInvokeMessage invokeMessage = (FunctionInvokeMessage)message;
                JSONObject mqttData = new JSONObject();
                mqttData.put("messageId", (Object)message.getMessageId());
                mqttData.put("deviceId", (Object)((FunctionInvokeMessage)message).getDeviceId());
                mqttData.put("function", (Object)invokeMessage.getFunctionId());
                mqttData.put("args", (Object)invokeMessage.getInputs());
                return SimpleMqttMessage.builder().topic(topic).payload(Unpooled.copiedBuffer((byte[])JSON.toJSONBytes((Object)mqttData, (SerializerFeature[])new SerializerFeature[0]))).build();
            }
            return null;
        });
    }
}

