/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp.message;

import java.util.HashMap;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.utils.BytesUtils;
import org.jetlinks.demo.protocol.tcp.TcpDeviceMessage;
import org.jetlinks.demo.protocol.tcp.TcpPayload;

public class FireAlarm
implements TcpPayload,
TcpDeviceMessage {
    private long deviceId;
    private float lnt;
    private float lat;
    private int point;

    @Override
    public DeviceMessage toDeviceMessage() {
        EventMessage message = new EventMessage();
        message.setEvent("fire_alarm");
        message.setMessageId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("lnt", Float.valueOf(this.lnt));
        map.put("lat", Float.valueOf(this.lat));
        map.put("point", this.point);
        message.setData(map);
        message.setDeviceId(String.valueOf(this.deviceId));
        return message;
    }

    @Override
    public byte[] toBytes() {
        byte[] data = new byte[20];
        BytesUtils.numberToLe((byte[])data, (Number)this.deviceId, (int)0, (int)8);
        BytesUtils.numberToLe((byte[])data, (Number)Float.floatToIntBits(this.lnt), (int)8, (int)4);
        BytesUtils.numberToLe((byte[])data, (Number)Float.floatToIntBits(this.lat), (int)12, (int)4);
        BytesUtils.numberToLe((byte[])data, (Number)this.point, (int)16, (int)4);
        return data;
    }

    @Override
    public void fromBytes(byte[] bytes, int offset) {
        this.setDeviceId(BytesUtils.leToLong((byte[])bytes, (int)offset, (int)8));
        this.setLnt(BytesUtils.leToFloat((byte[])bytes, (int)(offset + 8), (int)4));
        this.setLat(BytesUtils.leToFloat((byte[])bytes, (int)(offset + 12), (int)4));
        this.setPoint(BytesUtils.leToInt((byte[])bytes, (int)(offset + 16), (int)4));
    }

    public static FireAlarmBuilder builder() {
        return new FireAlarmBuilder();
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public float getLnt() {
        return this.lnt;
    }

    public float getLat() {
        return this.lat;
    }

    public int getPoint() {
        return this.point;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public void setLnt(float lnt) {
        this.lnt = lnt;
    }

    public void setLat(float lat) {
        this.lat = lat;
    }

    public void setPoint(int point) {
        this.point = point;
    }

    public FireAlarm() {
    }

    public FireAlarm(long deviceId, float lnt, float lat, int point) {
        this.deviceId = deviceId;
        this.lnt = lnt;
        this.lat = lat;
        this.point = point;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FireAlarm)) {
            return false;
        }
        FireAlarm other = (FireAlarm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDeviceId() != other.getDeviceId()) {
            return false;
        }
        if (Float.compare(this.getLnt(), other.getLnt()) != 0) {
            return false;
        }
        if (Float.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        return this.getPoint() == other.getPoint();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FireAlarm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $deviceId = this.getDeviceId();
        result = result * 59 + (int)($deviceId >>> 32 ^ $deviceId);
        result = result * 59 + Float.floatToIntBits(this.getLnt());
        result = result * 59 + Float.floatToIntBits(this.getLat());
        result = result * 59 + this.getPoint();
        return result;
    }

    public String toString() {
        return "FireAlarm(deviceId=" + this.getDeviceId() + ", lnt=" + this.getLnt() + ", lat=" + this.getLat() + ", point=" + this.getPoint() + ")";
    }

    public static class FireAlarmBuilder {
        private long deviceId;
        private float lnt;
        private float lat;
        private int point;

        FireAlarmBuilder() {
        }

        public FireAlarmBuilder deviceId(long deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public FireAlarmBuilder lnt(float lnt) {
            this.lnt = lnt;
            return this;
        }

        public FireAlarmBuilder lat(float lat) {
            this.lat = lat;
            return this;
        }

        public FireAlarmBuilder point(int point) {
            this.point = point;
            return this;
        }

        public FireAlarm build() {
            return new FireAlarm(this.deviceId, this.lnt, this.lat, this.point);
        }

        public String toString() {
            return "FireAlarm.FireAlarmBuilder(deviceId=" + this.deviceId + ", lnt=" + this.lnt + ", lat=" + this.lat + ", point=" + this.point + ")";
        }
    }
}

