/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.message.codec.http.FilePart;
import org.jetlinks.core.message.codec.http.FormFieldPart;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.Part;
import org.jetlinks.core.message.codec.http.SimplePart;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MultiPartParser {
    private static final SynchronossPartHttpMessageReader reader = new SynchronossPartHttpMessageReader();
    private static final NettyDataBufferFactory factory = new NettyDataBufferFactory(UnpooledByteBufAllocator.DEFAULT);
    private static final ResolvableType type = ResolvableType.forType(Part.class);

    MultiPartParser() {
    }

    static Mono<MultiPart> parser(HttpHeaders httpHeaders, Flux<ByteBuf> data) {
        return reader.read(type, new MultiPartParserReactiveHttpInputMessage(data, httpHeaders), Collections.emptyMap()).flatMap(part -> part.content().map(buf -> factory.wrap(buf.asByteBuffer())).collectList().filter(CollectionUtils::isNotEmpty).map(factory::join).cast(NettyDataBuffer.class).map(buffer -> MultiPartParser.convertPart(part, buffer.getNativeBuffer()))).collectList().filter(CollectionUtils::isNotEmpty).map(MultiPart::of);
    }

    private static Part convertPart(org.springframework.http.codec.multipart.Part part, ByteBuf byteBuf) {
        if (part instanceof org.springframework.http.codec.multipart.FilePart) {
            org.springframework.http.codec.multipart.FilePart filePart = (org.springframework.http.codec.multipart.FilePart)part;
            return FilePart.of(filePart.name(), filePart.filename(), filePart.headers(), byteBuf);
        }
        if (part instanceof org.springframework.http.codec.multipart.FormFieldPart) {
            org.springframework.http.codec.multipart.FormFieldPart formFieldPart = (org.springframework.http.codec.multipart.FormFieldPart)part;
            return FormFieldPart.of(formFieldPart.name(), formFieldPart.value(), formFieldPart.headers(), byteBuf);
        }
        return new SimplePart(part.name(), part.headers(), byteBuf);
    }

    static {
        reader.setMaxInMemorySize(-1);
    }

    static class MultiPartParserReactiveHttpInputMessage
    implements ReactiveHttpInputMessage {
        private final Flux<ByteBuf> data;
        private final HttpHeaders headers;

        @Override
        @Nonnull
        public Flux<DataBuffer> getBody() {
            return this.data.map(factory::wrap);
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public MultiPartParserReactiveHttpInputMessage(Flux<ByteBuf> data, HttpHeaders headers2) {
            this.data = data;
            this.headers = headers2;
        }
    }
}

