/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.event.DefaultEventMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.utils.SerializeUtils;

public interface ThingEventMessage
extends ThingMessage {
    public String getEvent();

    public Object getData();

    public ThingEventMessage event(String var1);

    public ThingEventMessage data(Object var1);

    @Override
    default public MessageType getMessageType() {
        return MessageType.EVENT;
    }

    public static EventMessage forDevice(String deviceId) {
        EventMessage message = new EventMessage();
        message.setDeviceId(deviceId);
        return message;
    }

    public static DefaultEventMessage forThing(ThingType thingType, String thingId) {
        DefaultEventMessage message = new DefaultEventMessage();
        message.setThingId(thingId);
        message.setThingType(thingType.getId());
        return message;
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        ThingMessage.super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.getEvent(), out);
        SerializeUtils.writeObject(this.getData(), out);
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ThingMessage.super.readExternal(in);
        this.event(SerializeUtils.readNullableUTF(in));
        this.data(SerializeUtils.readObject(in));
    }
}

