/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.tracing.TagExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUtils {
    static final HttpClosedException CLOSED_EXCEPTION = new HttpClosedException();
    static final int SC_SWITCHING_PROTOCOLS = 101;
    static final int SC_BAD_GATEWAY = 502;
    static final TagExtractor<HttpServerRequest> SERVER_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpServerRequest>(){

        @Override
        public int len(HttpServerRequest req) {
            return 2;
        }

        @Override
        public String name(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return "http.url";
                }
                case 1: {
                    return "http.method";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI();
                }
                case 1: {
                    return req.method().name();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpServerResponse> SERVER_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpServerResponse>(){

        @Override
        public int len(HttpServerResponse resp) {
            return 1;
        }

        @Override
        public String name(HttpServerResponse resp, int index) {
            if (index == 0) {
                return "http.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerResponse resp, int index) {
            if (index == 0) {
                return "" + resp.getStatusCode();
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpRequestHead> CLIENT_HTTP_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpRequestHead>(){

        @Override
        public int len(HttpRequestHead req) {
            return 2;
        }

        @Override
        public String name(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return "http.url";
                }
                case 1: {
                    return "http.method";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI;
                }
                case 1: {
                    return req.method.name();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpResponseHead> CLIENT_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpResponseHead>(){

        @Override
        public int len(HttpResponseHead resp) {
            return 1;
        }

        @Override
        public String name(HttpResponseHead resp, int index) {
            if (index == 0) {
                return "http.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpResponseHead resp, int index) {
            if (index == 0) {
                return "" + resp.statusCode;
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final StreamPriority DEFAULT_STREAM_PRIORITY = new StreamPriority(){

        @Override
        public StreamPriority setWeight(short weight) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setDependency(int dependency) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setExclusive(boolean exclusive) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }
    };
    private static final AsciiString TIMEOUT_EQ = AsciiString.of("timeout=");
    private static final Consumer<CharSequence> HEADER_VALUE_VALIDATOR = HttpUtils::validateHeaderValue;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -32;

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i2 = start; i2 < str.length(); ++i2) {
            if (str.charAt(i2) != '/') continue;
            return i2;
        }
        return -1;
    }

    private static boolean matches(CharSequence path2, int start, String what) {
        return HttpUtils.matches(path2, start, what, false);
    }

    private static boolean matches(CharSequence path2, int start, String what, boolean exact) {
        if (exact && path2.length() - start != what.length()) {
            return false;
        }
        if (path2.length() - start >= what.length()) {
            for (int i2 = 0; i2 < what.length(); ++i2) {
                if (path2.charAt(start + i2) == what.charAt(i2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizePath(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.length() == 0) {
            return "/";
        }
        StringBuilder ibuf = new StringBuilder(pathname.length() + 1);
        if (pathname.charAt(0) != '/') {
            ibuf.append('/');
        }
        ibuf.append(pathname);
        for (int i2 = 0; i2 < ibuf.length(); ++i2) {
            if (ibuf.charAt(i2) != '%') continue;
            HttpUtils.decodeUnreserved(ibuf, i2);
        }
        return HttpUtils.removeDots(ibuf);
    }

    private static void decodeUnreserved(StringBuilder path2, int start) {
        if (start + 3 <= path2.length()) {
            int unescaped;
            String escapeSequence = path2.substring(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path2.setCharAt(start, (char)unescaped);
                path2.delete(start + 1, start + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start);
        }
    }

    public static String removeDots(CharSequence path2) {
        if (path2 == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path2.length());
        int i2 = 0;
        while (i2 < path2.length()) {
            int pos;
            if (HttpUtils.matches(path2, i2, "./")) {
                i2 += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i2, "../")) {
                i2 += 3;
                continue;
            }
            if (HttpUtils.matches(path2, i2, "/./")) {
                i2 += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i2, "/.", true)) {
                path2 = "/";
                i2 = 0;
                continue;
            }
            if (HttpUtils.matches(path2, i2, "/../")) {
                i2 += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i2, "/..", true)) {
                path2 = "/";
                i2 = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i2, ".", true) || HttpUtils.matches(path2, i2, "..", true)) break;
            if (path2.charAt(i2) == '/') {
                ++i2;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path2, i2)) != -1) {
                obuf.append(path2, i2, pos);
                i2 = pos;
                continue;
            }
            obuf.append(path2, i2, path2.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path2;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path2 = HttpUtils.removeDots(_ref.getRawPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path2 = _ref.getRawPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getRawPath().length() == 0) {
                    path2 = base.getRawPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getRawPath().startsWith("/")) {
                        path2 = HttpUtils.removeDots(_ref.getRawPath());
                    } else {
                        int index;
                        String basePath = base.getRawPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref.getRawPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getRawPath() : _ref.getRawPath());
                        path2 = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path2, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i2;
        if (uri.length() == 0) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i2 = 0;
        } else {
            i2 = uri.indexOf("://");
            if (i2 == -1) {
                i2 = 0;
            } else if ((i2 = uri.indexOf(47, i2 + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i2);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i2, queryStart);
    }

    static String parseQuery(String uri) {
        int i2 = uri.indexOf(63);
        if (i2 == -1) {
            return null;
        }
        return uri.substring(i2 + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri, Charset charset) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri, charset);
        Map<String, List<String>> prms = queryStringDecoder.parameters();
        MultiMap params = MultiMap.caseInsensitiveMultiMap();
        if (!prms.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                params.add(entry.getKey(), (Iterable<String>)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', vertxSettings.getHeaderTableSize());
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != 8192L) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), (Long)setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), (Long)value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i2 = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i2, j);
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer(Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer(reason, StandardCharsets.UTF_8));
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static void sendError(Channel ch, HttpResponseStatus status) {
        HttpUtils.sendError(ch, status, status.reasonPhrase());
    }

    static void sendError(Channel ch, HttpResponseStatus status, CharSequence err) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            HttpUtil.setContentLength(resp, err.length());
        } else {
            HttpUtil.setContentLength(resp, 0L);
        }
        ch.writeAndFlush(resp);
    }

    static String getWebSocketLocation(HttpServerRequest req, boolean ssl) throws Exception {
        String prefix = ssl ? "wss://" : "ws://";
        URI uri = new URI(req.uri());
        String path2 = uri.getRawPath();
        String loc = prefix + req.headers().get(HttpHeaderNames.HOST) + path2;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    public static CharSequence toLowerCase(CharSequence sequence) {
        StringBuilder buffer = null;
        int len = sequence.length();
        for (int index = 0; index < len; ++index) {
            char c = sequence.charAt(index);
            if (c < 'A' || c > 'Z') continue;
            if (buffer == null) {
                buffer = new StringBuilder(sequence);
            }
            buffer.setCharAt(index, (char)(c + 32));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return sequence;
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpMethod toVertxMethod(String method2) {
        return HttpMethod.valueOf(method2);
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next;
            int idx = AsciiString.indexOf(value, ',', pos);
            if (idx == -1) {
                idx = next = len;
            } else {
                next = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches(value, true, pos, TIMEOUT_EQ, 0, TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        HttpUtils.validateHeaderName(name);
        if (value != null) {
            HttpUtils.validateHeaderValue(value);
        }
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        HttpUtils.validateHeaderName(name);
        values.forEach(value -> {
            if (value != null) {
                HEADER_VALUE_VALIDATOR.accept((CharSequence)value);
            }
        });
    }

    public static void validateHeaderValue(CharSequence seq) {
        int state = 0;
        for (int index = 0; index < seq.length(); ++index) {
            state = HttpUtils.validateValueChar(seq, state, seq.charAt(index));
        }
        if (state != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
        }
    }

    private static int validateValueChar(CharSequence seq, int state, char character) {
        if ((character & 0xFFFFFFE0) == 0 || character == '\u007f') {
            switch (character) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("a header value contains a prohibited character '" + character + "': " + seq);
                }
            }
        }
        switch (state) {
            case 0: {
                switch (character) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (character) {
                    case '\n': {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
            }
            case 2: {
                switch (character) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
            }
        }
        return state;
    }

    public static void validateHeaderName(CharSequence value) {
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            switch (c) {
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': 
                case '\u007f': {
                    throw new IllegalArgumentException("a header name cannot contain some prohibited characters, such as : " + value);
                }
            }
            if (c < ' ') {
                throw new IllegalArgumentException("a header name cannot contain control characters: " + value);
            }
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + value);
        }
    }

    public static boolean isValidMultipartContentType(String contentType2) {
        return HttpHeaderValues.MULTIPART_FORM_DATA.regionMatches(true, 0, contentType2, 0, HttpHeaderValues.MULTIPART_FORM_DATA.length()) || HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.regionMatches(true, 0, contentType2, 0, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.length());
    }

    public static boolean isValidMultipartMethod(io.netty.handler.codec.http.HttpMethod method2) {
        return method2.equals(io.netty.handler.codec.http.HttpMethod.POST) || method2.equals(io.netty.handler.codec.http.HttpMethod.PUT) || method2.equals(io.netty.handler.codec.http.HttpMethod.PATCH) || method2.equals(io.netty.handler.codec.http.HttpMethod.DELETE);
    }

    static void resolveFile(VertxInternal vertx, String filename, long offset, long length, Handler<AsyncResult<AsyncFile>> resultHandler) {
        File file_ = vertx.resolveFile(filename);
        if (!file_.exists()) {
            resultHandler.handle(Future.failedFuture(new FileNotFoundException()));
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file_, "r");){
            FileSystem fs = vertx.fileSystem();
            fs.open(filename, new OpenOptions().setCreate(false).setWrite(false), ar -> {
                if (ar.succeeded()) {
                    AsyncFile file = (AsyncFile)ar.result();
                    long contentLength = Math.min(length, file_.length() - offset);
                    file.setReadPos(offset);
                    file.setReadLength(contentLength);
                }
                resultHandler.handle((AsyncResult<AsyncFile>)ar);
            });
        }
        catch (IOException e) {
            resultHandler.handle(Future.failedFuture(e));
        }
    }

    static boolean isConnectOrUpgrade(HttpMethod method2, MultiMap headers2) {
        return method2 == HttpMethod.CONNECT || method2 == HttpMethod.GET && headers2.contains(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE, true);
    }
}

