/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp.message;

import java.util.Collections;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.utils.BytesUtils;
import org.jetlinks.demo.protocol.tcp.TcpDeviceMessage;
import org.jetlinks.demo.protocol.tcp.TcpPayload;

public class TemperatureReport
implements TcpPayload,
TcpDeviceMessage {
    private long deviceId;
    private float temperature;

    @Override
    public DeviceMessage toDeviceMessage() {
        ReportPropertyMessage message = new ReportPropertyMessage();
        message.setProperties(Collections.singletonMap("temperature", Float.valueOf(this.temperature)));
        message.setDeviceId(String.valueOf(this.deviceId));
        message.setTimestamp(System.currentTimeMillis());
        return message;
    }

    @Override
    public byte[] toBytes() {
        byte[] data = new byte[12];
        BytesUtils.toHighBytes((byte[])data, (long)this.deviceId, (int)0, (int)8);
        BytesUtils.toHighBytes((byte[])data, (long)Float.floatToIntBits(this.temperature), (int)8, (int)4);
        return data;
    }

    @Override
    public void fromBytes(byte[] bytes, int offset) {
        this.deviceId = BytesUtils.highBytesToLong((byte[])bytes, (int)offset, (int)8);
        this.temperature = BytesUtils.highBytesToFloat((byte[])bytes, (int)(offset + 8), (int)4);
    }

    public String toString() {
        return "TemperatureReport{deviceId=" + this.deviceId + ", temperature=" + this.temperature + '}';
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    private TemperatureReport(long deviceId, float temperature) {
        this.deviceId = deviceId;
        this.temperature = temperature;
    }

    public static TemperatureReport of(long deviceId, float temperature) {
        return new TemperatureReport(deviceId, temperature);
    }

    public TemperatureReport() {
    }
}

