/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.client.UriEndpoint;
import reactor.util.annotation.Nullable;

final class UriEndpointFactory {
    final Supplier<? extends SocketAddress> connectAddress;
    final boolean defaultSecure;
    final BiFunction<String, Integer, InetSocketAddress> inetSocketAddressFunction;
    static final Pattern URL_PATTERN = Pattern.compile("(?:(\\w+)://)?((?:\\[.+?])|(?<!\\[)(?:[^/?]+?))(?::(\\d{2,5}))?([/?].*)?");

    UriEndpointFactory(Supplier<? extends SocketAddress> connectAddress, boolean defaultSecure, BiFunction<String, Integer, InetSocketAddress> inetSocketAddressFunction) {
        this.connectAddress = connectAddress;
        this.defaultSecure = defaultSecure;
        this.inetSocketAddressFunction = inetSocketAddressFunction;
    }

    UriEndpoint createUriEndpoint(String url, boolean isWs) {
        return this.createUriEndpoint(url, isWs, this.connectAddress);
    }

    UriEndpoint createUriEndpoint(String url, boolean isWs, Supplier<? extends SocketAddress> connectAddress) {
        if (url.startsWith("/")) {
            return new UriEndpoint(this.resolveScheme(isWs), "localhost", 80, connectAddress, url);
        }
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            String scheme = matcher.group(1) != null ? matcher.group(1).toLowerCase() : this.resolveScheme(isWs);
            String host = this.cleanHostString(matcher.group(2));
            String portString = matcher.group(3);
            int port = portString != null ? Integer.parseInt(portString) : (UriEndpoint.isSecureScheme(scheme) ? 443 : 80);
            String pathAndQuery = this.cleanPathAndQuery(matcher.group(4));
            return new UriEndpoint(scheme, host, port, () -> this.inetSocketAddressFunction.apply(host, port), pathAndQuery);
        }
        throw new IllegalArgumentException("Unable to parse url [" + url + "]");
    }

    UriEndpoint createUriEndpoint(URI url, boolean isWs) {
        if (!url.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute: " + url);
        }
        if (url.getHost() == null) {
            throw new IllegalArgumentException("Host is not specified");
        }
        String scheme = url.getScheme() != null ? url.getScheme().toLowerCase() : this.resolveScheme(isWs);
        String host = this.cleanHostString(url.getHost());
        int port = url.getPort() != -1 ? url.getPort() : (UriEndpoint.isSecureScheme(scheme) ? 443 : 80);
        String path2 = url.getRawPath() != null ? url.getRawPath() : "";
        String query = url.getRawQuery() != null ? '?' + url.getRawQuery() : "";
        return new UriEndpoint(scheme, host, port, () -> this.inetSocketAddressFunction.apply(host, port), this.cleanPathAndQuery(path2 + query));
    }

    UriEndpoint createUriEndpoint(UriEndpoint from, String to, Supplier<? extends SocketAddress> connectAddress) {
        if (to.startsWith("/")) {
            return new UriEndpoint(from.scheme, from.host, from.port, connectAddress, to);
        }
        throw new IllegalArgumentException("Must provide a relative address in parameter `to`");
    }

    String cleanPathAndQuery(@Nullable String pathAndQuery) {
        if (pathAndQuery == null) {
            pathAndQuery = "/";
        } else {
            int pos = pathAndQuery.indexOf(35);
            if (pos > -1) {
                pathAndQuery = pathAndQuery.substring(0, pos);
            }
        }
        if (pathAndQuery.length() == 0) {
            pathAndQuery = "/";
        } else if (pathAndQuery.charAt(0) == '?') {
            pathAndQuery = "/" + pathAndQuery;
        }
        return pathAndQuery;
    }

    String cleanHostString(String host) {
        if (host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        return host;
    }

    String resolveScheme(boolean isWs) {
        if (isWs) {
            return this.defaultSecure ? "wss" : "ws";
        }
        return this.defaultSecure ? "https" : "http";
    }
}

