/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springframework.cache.interceptor.VariableNotAvailableException;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;

class CacheEvaluationContext
extends MethodBasedEvaluationContext {
    private final Set<String> unavailableVariables = new HashSet<String>(1);

    CacheEvaluationContext(Object rootObject, Method method2, Object[] arguments, ParameterNameDiscoverer parameterNameDiscoverer) {
        super(rootObject, method2, arguments, parameterNameDiscoverer);
    }

    public void addUnavailableVariable(String name) {
        this.unavailableVariables.add(name);
    }

    @Override
    @Nullable
    public Object lookupVariable(String name) {
        if (this.unavailableVariables.contains(name)) {
            throw new VariableNotAvailableException(name);
        }
        return super.lookupVariable(name);
    }
}

