/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.from;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.select.ExceptOp;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.IntersectOp;
import net.sf.jsqlparser.statement.select.MinusOp;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.UnionOp;
import org.jetlinks.reactor.ql.DefaultReactorQL;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FromFeature;
import org.jetlinks.reactor.ql.supports.DefaultReactorQLMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubSelectFromFeature
implements FromFeature {
    private Function<ReactorQLContext, Flux<ReactorQLRecord>> doCreateMapper(String alias, SelectBody body2, ReactorQLMetadata metadata) {
        if (body2 instanceof PlainSelect) {
            DefaultReactorQL reactorQL = new DefaultReactorQL(new DefaultReactorQLMetadata((PlainSelect)body2));
            return ctx -> reactorQL.start((ReactorQLContext)ctx).map(record -> record.resultToRecord(alias == null ? record.getName() : alias));
        }
        if (body2 instanceof SetOperationList) {
            SetOperationList setOperation = (SetOperationList)body2;
            List<SelectBody> selects = setOperation.getSelects();
            List<SetOperation> operations = setOperation.getOperations();
            SelectBody select = selects.get(0);
            Function<ReactorQLContext, Flux<ReactorQLRecord>> firstMapper = this.doCreateMapper(alias, select, metadata);
            for (int i2 = 1; i2 < selects.size(); ++i2) {
                SetOperation operation = operations.get(i2 - 1);
                Function<ReactorQLContext, Flux<ReactorQLRecord>> tmp = firstMapper;
                Function<ReactorQLContext, Flux<ReactorQLRecord>> mapper = this.doCreateMapper(alias, selects.get(i2), metadata);
                BiFunction<Set, Set, Collection> operator = null;
                if (operation instanceof UnionOp) {
                    if (((UnionOp)operation).isAll()) {
                        firstMapper = ctx -> ((Flux)tmp.apply((ReactorQLContext)ctx)).mergeWith((Publisher)mapper.apply((ReactorQLContext)ctx));
                        continue;
                    }
                    firstMapper = ctx -> ((Flux)tmp.apply((ReactorQLContext)ctx)).mergeWith((Publisher)mapper.apply((ReactorQLContext)ctx)).distinct(ReactorQLRecord::getRecord);
                    continue;
                }
                if (operation instanceof MinusOp) {
                    operator = (left, right) -> {
                        left.removeAll((Collection<?>)right);
                        return left;
                    };
                } else if (operation instanceof ExceptOp) {
                    operator = (left, right) -> {
                        right.removeAll((Collection<?>)left);
                        return right;
                    };
                } else if (operation instanceof IntersectOp) {
                    operator = (left, right) -> {
                        left.retainAll((Collection<?>)right);
                        return left;
                    };
                }
                if (operator == null) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c:" + body2);
                }
                BiFunction<Set, Set, Collection> fiOperator = operator;
                firstMapper = ctx -> Mono.zip(((Flux)tmp.apply((ReactorQLContext)ctx)).collect(Collectors.toSet()), ((Flux)mapper.apply((ReactorQLContext)ctx)).collect(Collectors.toSet()), fiOperator).flatMapIterable(Function.identity());
            }
            return firstMapper;
        }
        return FromFeature.createFromMapperByBody(body2, metadata);
    }

    @Override
    public Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapper(FromItem fromItem, ReactorQLMetadata metadata) {
        SubSelect subSelect = (SubSelect)fromItem;
        SelectBody body2 = subSelect.getSelectBody();
        return this.doCreateMapper(subSelect.getAlias() == null ? null : subSelect.getAlias().getName(), body2, metadata);
    }

    @Override
    public String getId() {
        return FeatureId.From.subSelect.getId();
    }
}

