/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FormatSupport;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ObjectType
extends AbstractType<ObjectType>
implements DataType,
Converter<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(ObjectType.class);
    public static final String ID = "object";
    private List<PropertyMetadata> properties;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "\u5bf9\u8c61\u7c7b\u578b";
    }

    public ObjectType addPropertyMetadata(PropertyMetadata property) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyMetadata>();
        }
        this.properties.add(property);
        return this;
    }

    public List<PropertyMetadata> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return this.properties;
    }

    public ObjectType addProperty(String property, DataType type) {
        return this.addProperty(property, property, type);
    }

    public ObjectType addProperty(String property, String name, DataType type) {
        SimplePropertyMetadata metadata = new SimplePropertyMetadata();
        metadata.setId(property);
        metadata.setName(name);
        metadata.setValueType(type);
        return this.addPropertyMetadata(metadata);
    }

    @Override
    public ValidateResult validate(Object value) {
        if (this.properties == null || this.properties.isEmpty()) {
            return ValidateResult.success(value);
        }
        Object mapValue = this.convert(value);
        for (PropertyMetadata property : this.properties) {
            ValidateResult result;
            Object data = mapValue.get(property.getId());
            if (data == null || (result = property.getValueType().validate(data)).isSuccess()) continue;
            return result;
        }
        return ValidateResult.success(mapValue);
    }

    @Override
    public JSONObject format(Object value) {
        return new JSONObject(this.handle(value, FormatSupport::format));
    }

    public Map<String, Object> handle(Object value, BiFunction<DataType, Object, Object> mapping) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)((Object)value)).startsWith("{")) {
            value = JSON.parseObject(String.valueOf(value));
        }
        if (!(value instanceof Map)) {
            value = FastBeanCopier.copy(value, new HashMap(), new String[0]);
        }
        if (value instanceof Map) {
            HashMap<String, Object> mapValue = new HashMap<String, Object>(value);
            if (this.properties != null) {
                for (PropertyMetadata property : this.properties) {
                    Object data = mapValue.get(property.getId());
                    DataType type = property.getValueType();
                    if (data == null) continue;
                    mapValue.put(property.getId(), mapping.apply(type, data));
                }
            }
            return mapValue;
        }
        return null;
    }

    @Override
    public Map<String, Object> convert(Object value) {
        return this.handle(value, (type, data) -> {
            if (type instanceof Converter) {
                return ((Converter)((Object)type)).convert(data);
            }
            return data;
        });
    }

    public Optional<PropertyMetadata> getProperty(String key) {
        if (CollectionUtils.isEmpty(this.properties)) {
            return Optional.empty();
        }
        return this.properties.stream().filter(prop -> prop.getId().equals(key)).findAny();
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.properties = properties;
    }
}

