/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WritePropertyMessageSender {
    public WritePropertyMessageSender custom(Consumer<WritePropertyMessage> var1);

    public WritePropertyMessageSender header(String var1, Object var2);

    public WritePropertyMessageSender messageId(String var1);

    public WritePropertyMessageSender write(String var1, Object var2);

    public Mono<WritePropertyMessageSender> validate();

    public Flux<WritePropertyMessageReply> send();

    default public Mono<Void> sendAndForget() {
        return this.header(Headers.sendAndForget, true).async().send().then();
    }

    default public WritePropertyMessageSender write(Map<String, Object> properties) {
        properties.forEach(this::write);
        return this;
    }

    default public WritePropertyMessageSender accept(Consumer<WritePropertyMessageSender> consumer) {
        consumer.accept(this);
        return this;
    }

    default public WritePropertyMessageSender timeout(Duration timeout) {
        return this.header(Headers.timeout, timeout.toMillis());
    }

    default public WritePropertyMessageSender async() {
        return this.async(true);
    }

    default public WritePropertyMessageSender async(Boolean async) {
        return this.header(Headers.async, async);
    }

    default public <T> WritePropertyMessageSender header(HeaderKey<T> header, T value) {
        return this.header(header.getKey(), value);
    }

    default public WritePropertyMessageSender headers(Map<String, Object> headers2) {
        Objects.requireNonNull(headers2).forEach(this::header);
        return this;
    }
}

