/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.i18n;

import java.util.Locale;
import org.hswebframework.web.i18n.LocaleUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebFluxLocaleFilter
implements WebFilter {
    @Override
    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange2, WebFilterChain chain) {
        return chain.filter(exchange2).as(LocaleUtils::transform).subscriberContext(LocaleUtils.useLocale(this.getLocaleContext(exchange2)));
    }

    public Locale getLocaleContext(ServerWebExchange exchange2) {
        String lang = exchange2.getRequest().getQueryParams().getFirst(":lang");
        if (StringUtils.hasText(lang)) {
            return Locale.forLanguageTag(lang);
        }
        Locale locale = exchange2.getLocaleContext().getLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }
}

