/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetlinks.core.utils.CyclicDependencyChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

class SimpleCyclicDependencyChecker<T, ID, R>
implements CyclicDependencyChecker<T, R> {
    private static final Logger log = LoggerFactory.getLogger(SimpleCyclicDependencyChecker.class);
    private final Function<T, ID> idGetter;
    private final Function<T, ID> parentIdGetter;
    private final Function<ID, Mono<T>> dataGetter;
    private final Function<Set<ID>, Mono<R>> action;

    @Override
    public Mono<R> check(T target) {
        return this.doCheck(target, new LinkedHashSet());
    }

    private Mono<R> doCheck(T target, Set<ID> checked) {
        ID id = this.idGetter.apply(target);
        if (checked.contains(id)) {
            this.log(target.getClass(), checked);
            return this.action.apply(checked);
        }
        ID parentId = this.parentIdGetter.apply(target);
        if (StringUtils.isEmpty(parentId)) {
            return Mono.empty();
        }
        checked.add(id);
        return this.dataGetter.apply(parentId).flatMap(parent -> this.doCheck(parent, checked));
    }

    private void log(Class<?> type, Set<ID> checked) {
        log.warn("{} has a cyclic dependency: {}", (Object)type.getSimpleName(), (Object)checked.stream().map(String::valueOf).collect(Collectors.joining(" -> ")));
    }

    public SimpleCyclicDependencyChecker(Function<T, ID> idGetter, Function<T, ID> parentIdGetter, Function<ID, Mono<T>> dataGetter, Function<Set<ID>, Mono<R>> action) {
        this.idGetter = idGetter;
        this.parentIdGetter = parentIdGetter;
        this.dataGetter = dataGetter;
        this.action = action;
    }
}

