/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.List;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingType;
import reactor.core.publisher.Mono;

public interface ThingsDataManager {
    public Mono<ThingProperty> getLastProperty(String var1, String var2, String var3, long var4);

    public Mono<ThingProperty> getFirstProperty(String var1, String var2, String var3);

    public Mono<Long> getLastPropertyTime(String var1, String var2, long var3);

    public Mono<Long> getFirstPropertyTime(String var1, String var2);

    default public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long from, long to) {
        return this.getLastProperty(thingType, thingId, property, to).expandDeep(prop -> this.getLastProperty(thingType, thingId, property, prop.getTimestamp() - 1L).filter(p -> p.getTimestamp() >= from)).collectList();
    }

    default public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long baseTime) {
        return this.getProperties(thingType, thingId, property, 0L, baseTime);
    }

    default public Mono<ThingProperty> getLastProperty(ThingType thingType, String thingId, String property, long baseTime) {
        return this.getLastProperty(thingType.getId(), thingId, property, baseTime);
    }

    default public Mono<ThingProperty> getFirstProperty(ThingType thingType, String thingId, String property) {
        return this.getFirstProperty(thingType.getId(), thingId, property);
    }

    default public Mono<Long> getLastPropertyTime(ThingType thingType, String thingId, long baseTime) {
        return this.getLastPropertyTime(thingType.getId(), thingId, baseTime);
    }

    default public Mono<Long> getFirstPropertyTime(ThingType thingType, String thingId) {
        return this.getFirstPropertyTime(thingType.getId(), thingId);
    }
}

