/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import io.netty.util.ReferenceCountUtil;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

public class LostDeviceSession
implements DeviceSession {
    private final String id;
    private final DeviceOperator operator;
    private final Transport transport;

    @Override
    public String getDeviceId() {
        return this.operator.getDeviceId();
    }

    @Override
    public long lastPingTime() {
        return -1L;
    }

    @Override
    public long connectTime() {
        return -1L;
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return Mono.error(new DeviceOperationException(ErrorCode.CONNECTION_LOST)).doAfterTerminate(() -> ReferenceCountUtil.safeRelease(encodedMessage.getPayload()));
    }

    @Override
    public void close() {
    }

    @Override
    public void ping() {
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public void onClose(Runnable call) {
    }

    @Override
    public boolean isChanged(DeviceSession another) {
        return !another.isWrapFrom(LostDeviceSession.class);
    }

    @Override
    public Mono<Boolean> isAliveAsync() {
        return Reactors.ALWAYS_FALSE;
    }

    public LostDeviceSession(String id, DeviceOperator operator, Transport transport) {
        this.id = id;
        this.operator = operator;
        this.transport = transport;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DeviceOperator getOperator() {
        return this.operator;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }
}

