/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.jetlinks.core.message.codec.Transports;

public interface Transport {
    public String getId();

    default public String getName() {
        return this.getId();
    }

    default public String getDescription() {
        return null;
    }

    default public boolean isSame(Transport transport) {
        return this == transport || this.getId().equals(transport.getId());
    }

    default public boolean isSame(String transportId) {
        return this.getId().equals(transportId);
    }

    public static Transport of(String id) {
        return Transport.lookup(id).orElseGet(() -> (Transport & Serializable)() -> id);
    }

    public static Optional<Transport> lookup(String id) {
        return Transports.lookup(id);
    }

    public static List<Transport> getAll() {
        return Transports.get();
    }
}

