/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.collections.set.CompositeSet;

public class CompositeMap
implements Map {
    private Map[] composite;
    private MapMutator mutator;

    public CompositeMap() {
        this(new Map[0], null);
    }

    public CompositeMap(Map one, Map two) {
        this(new Map[]{one, two}, null);
    }

    public CompositeMap(Map one, Map two, MapMutator mutator) {
        this(new Map[]{one, two}, mutator);
    }

    public CompositeMap(Map[] composite) {
        this(composite, null);
    }

    public CompositeMap(Map[] composite, MapMutator mutator) {
        this.mutator = mutator;
        this.composite = new Map[0];
        for (int i2 = composite.length - 1; i2 >= 0; --i2) {
            this.addComposited(composite[i2]);
        }
    }

    public void setMutator(MapMutator mutator) {
        this.mutator = mutator;
    }

    public synchronized void addComposited(Map map) throws IllegalArgumentException {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            Collection intersect = CollectionUtils.intersection(this.composite[i2].keySet(), map.keySet());
            if (intersect.size() == 0) continue;
            if (this.mutator == null) {
                throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
            }
            this.mutator.resolveCollision(this, this.composite[i2], map, intersect);
        }
        Map[] temp = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, temp, 0, this.composite.length);
        temp[temp.length - 1] = map;
        this.composite = temp;
    }

    public synchronized Map removeComposited(Map map) {
        int size = this.composite.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!this.composite[i2].equals(map)) continue;
            Map[] temp = new Map[size - 1];
            System.arraycopy(this.composite, 0, temp, 0, i2);
            System.arraycopy(this.composite, i2 + 1, temp, i2, size - i2 - 1);
            this.composite = temp;
            return map;
        }
        return null;
    }

    public void clear() {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            this.composite[i2].clear();
        }
    }

    public boolean containsKey(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        CompositeSet entries = new CompositeSet();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            entries.addComposited(this.composite[i2].entrySet());
        }
        return entries;
    }

    public Object get(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return this.composite[i2].get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (this.composite[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set keySet() {
        CompositeSet keys = new CompositeSet();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            keys.addComposited(this.composite[i2].keySet());
        }
        return keys;
    }

    public Object put(Object key, Object value) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        return this.mutator.put(this, this.composite, key, value);
    }

    public void putAll(Map map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        this.mutator.putAll(this, this.composite, map);
    }

    public Object remove(Object key) {
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            if (!this.composite[i2].containsKey(key)) continue;
            return this.composite[i2].remove(key);
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            size += this.composite[i2].size();
        }
        return size;
    }

    public Collection values() {
        CompositeCollection keys = new CompositeCollection();
        for (int i2 = this.composite.length - 1; i2 >= 0; --i2) {
            keys.addComposited(this.composite[i2].values());
        }
        return keys;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        Iterator i2 = this.entrySet().iterator();
        while (i2.hasNext()) {
            code += i2.next().hashCode();
        }
        return code;
    }

    public static interface MapMutator {
        public void resolveCollision(CompositeMap var1, Map var2, Map var3, Collection var4);

        public Object put(CompositeMap var1, Map[] var2, Object var3, Object var4);

        public void putAll(CompositeMap var1, Map[] var2, Map var3);
    }
}

