/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.tcp.message;

import org.jetlinks.core.utils.BytesUtils;
import org.jetlinks.demo.protocol.tcp.TcpPayload;
import org.jetlinks.demo.protocol.tcp.TcpStatus;

public class AuthResponse
implements TcpPayload {
    private long deviceId;
    private TcpStatus status;

    public static AuthResponse of(byte[] bytes, int offset) {
        AuthResponse response = new AuthResponse();
        response.fromBytes(bytes, offset);
        return response;
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[9];
        BytesUtils.numberToLe((byte[])bytes, (Number)this.deviceId, (int)0, (int)8);
        bytes[8] = this.status.getStatus();
        return bytes;
    }

    @Override
    public void fromBytes(byte[] bytes, int offset) {
        this.setDeviceId(BytesUtils.leToLong((byte[])bytes, (int)offset, (int)8));
        this.setStatus(TcpStatus.of(bytes[offset + 8]).orElse(TcpStatus.UNKNOWN));
    }

    public String toString() {
        return "{deviceId=" + this.deviceId + ", status=" + (Object)((Object)this.status) + '}';
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public TcpStatus getStatus() {
        return this.status;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public void setStatus(TcpStatus status) {
        this.status = status;
    }

    private AuthResponse(long deviceId, TcpStatus status) {
        this.deviceId = deviceId;
        this.status = status;
    }

    public static AuthResponse of(long deviceId, TcpStatus status) {
        return new AuthResponse(deviceId, status);
    }

    public AuthResponse() {
    }
}

