/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network.tcp;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class TcpOptions
extends NetClientOptions {
    private String id;
    private String host;
    private int port;
    private Integer fixedLength;
    private String delimited;
    private Integer[] lengthField;

    public TcpOptions() {
    }

    public Consumer<Buffer> createParser(Consumer<Buffer> handler) {
        ReadStream parser = null;
        if (this.fixedLength != null) {
            parser = RecordParser.newFixed(this.fixedLength).handler(handler::accept);
        } else if (this.delimited != null) {
            parser = RecordParser.newDelimited(this.delimited).handler(handler::accept);
        }
        if (this.lengthField != null && this.lengthField.length > 0) {
            Function<Buffer, Integer> fieldReader;
            int len = this.lengthField.length >= 2 ? this.lengthField[1] : this.lengthField[0];
            int offset = this.lengthField.length >= 2 ? this.lengthField[0] : 0;
            RecordParser temp = RecordParser.newFixed(len + offset);
            AtomicReference current = new AtomicReference();
            if (len == 1) {
                fieldReader = buf -> buf.getUnsignedByte(offset);
            } else if (len == 2) {
                fieldReader = buf -> buf.getUnsignedShort(offset);
            } else if (len == 3) {
                fieldReader = buf -> buf.getMedium(offset);
            } else if (len == 4) {
                fieldReader = buf -> buf.getInt(offset);
            } else {
                throw new IllegalArgumentException("lengthField only support [2,3,4]");
            }
            parser = temp.handler(buff -> {
                if (current.get() == null) {
                    current.set(buff);
                    int next = (Integer)fieldReader.apply((Buffer)buff);
                    temp.fixedSizeMode(next);
                } else {
                    temp.fixedSizeMode(len + offset);
                    Buffer buffer = current.getAndSet(null);
                    handler.accept(buffer.appendBuffer((Buffer)buff));
                }
            });
        }
        return parser == null ? handler : ((RecordParser)parser)::handle;
    }

    private TcpOptions(TcpOptions options) {
        super(options);
        this.id = options.getId();
        this.host = options.getHost();
        this.port = options.getPort();
        this.lengthField = options.getLengthField();
        this.fixedLength = options.getFixedLength();
        this.delimited = options.getDelimited();
    }

    public String toString() {
        return "tcp://" + this.host + ":" + this.port;
    }

    public TcpOptions copy() {
        return new TcpOptions(this);
    }

    private TcpOptions apply(Map<String, Object> args) {
        if (this.id == null) {
            return this;
        }
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String key = "{" + entry.getKey() + "}";
            String value = String.valueOf(entry.getValue());
            this.id = this.id.replace(key, value);
        }
        return this;
    }

    public TcpOptions refactor(Map<String, Object> args) {
        return this.copy().apply(args);
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getFixedLength() {
        return this.fixedLength;
    }

    public String getDelimited() {
        return this.delimited;
    }

    public Integer[] getLengthField() {
        return this.lengthField;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setFixedLength(Integer fixedLength) {
        this.fixedLength = fixedLength;
    }

    public void setDelimited(String delimited) {
        this.delimited = delimited;
    }

    public void setLengthField(Integer[] lengthField) {
        this.lengthField = lengthField;
    }
}

