/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.upd;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.vertx.core.datagram.DatagramPacket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.cmd.ConnectionAttachCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.udp.UDPClient;
import org.jline.utils.AttributedString;
import org.joda.time.DateTime;
import picocli.CommandLine;

@CommandLine.Command(name="attach", description={"Attach UDP Client"})
public class UDPAttachCommand
extends ConnectionAttachCommand {
    @Override
    @CommandLine.Parameters(paramLabel="id", completionCandidates=IdComplete.class)
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    protected void doInit() {
        this.disposable.add(this.connection.unwrap(UDPClient.class).handle(this::appendMessage));
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
    }

    @Override
    protected void createHeader(List<AttributedString> lines) {
        super.createHeader(lines);
        lines.add(UDPAttachCommand.createLine(builder -> {
            UDPClient client = this.connection.unwrap(UDPClient.class);
            builder.append("          ");
            builder.append("Remote Address: ");
            builder.append(client.getRemote().toString(), green);
            builder.append(" Local Address: ");
            builder.append(client.getLocal().toString(), green);
        }));
    }

    @Override
    protected AbstractCommand createCommand() {
        return new AttachCommands();
    }

    private void appendMessage(DatagramPacket message) {
        ArrayList<AttributedString> msgLine = new ArrayList<AttributedString>();
        msgLine.add(UDPAttachCommand.createLine(builder -> builder.append(new DateTime().toString("HH:mm:ss"), red).append(" ").append(message.sender().hostAddress() + ":" + message.sender().port(), green)));
        ByteBuf byteBuf = message.data().getByteBuf();
        String str = ByteBufUtil.isText(byteBuf, StandardCharsets.UTF_8) ? byteBuf.toString(StandardCharsets.UTF_8) : ByteBufUtil.prettyHexDump(byteBuf);
        for (String n : str.split("\n")) {
            msgLine.add(UDPAttachCommand.createLine(builder -> builder.append(n, green)));
        }
        this.messages.add(msgLine);
        if (this.messages.size() > 50) {
            this.messages.removeFirst();
        }
    }

    @CommandLine.Command(name="close", description={"Close UDP Client"})
    static class Close
    extends CommonCommand {
        Close() {
        }

        @Override
        public void run() {
            ((AttachCommands)this.parent).disconnect();
        }
    }

    @CommandLine.Command(name="send", description={"Send UDP packet"})
    static class Send
    extends CommonCommand {
        @CommandLine.Option(names={"-h", "--host"}, description={"Sent to custom host"})
        String host;
        @CommandLine.Option(names={"-p", "--port"}, description={"Sent to custom port"})
        int port;
        @CommandLine.Parameters(arity="1", description={"0x\u5f00\u5934\u4e3a16\u8fdb\u5236"})
        String payload;

        Send() {
        }

        @Override
        public void run() {
            ((AttachCommands)this.getParent()).publish(this);
        }
    }

    @CommandLine.Command(name="", subcommands={Send.class, Close.class}, customSynopsis={""}, synopsisHeading="")
    class AttachCommands
    extends CommonCommand {
        AttachCommands() {
        }

        void publish(Send publish) {
            UDPClient client = UDPAttachCommand.this.connection.unwrap(UDPClient.class);
            try {
                this.printf("sending ", new Object[0]);
                if (publish.host != null && publish.port > 0) {
                    client.sendAsync(publish.host, publish.port, publish.payload).block(Duration.ofSeconds(10L));
                } else {
                    client.sendAsync(publish.payload).block(Duration.ofSeconds(10L));
                }
                this.printf("success!%n", new Object[0]);
            }
            catch (Throwable e) {
                this.printfError("error:%s%n", ExceptionUtils.getErrorMessage(e));
            }
        }

        void disconnect() {
            UDPAttachCommand.this.connection.dispose();
        }
    }

    static class IdComplete
    implements Iterable<String> {
        IdComplete() {
        }

        @Override
        public Iterator<String> iterator() {
            return ConnectionManager.global().getConnections().filter(c -> c.getType() == NetworkType.udp_client).map(Connection::getId).collectList().block().iterator();
        }
    }
}

