/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.benchmark;

import java.util.Collections;
import org.jetlinks.simulator.cmd.NetClientCommandOption;
import org.jetlinks.simulator.cmd.benchmark.AbstractBenchmarkCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.Global;
import org.jetlinks.simulator.core.benchmark.ConnectCreateContext;
import org.jetlinks.simulator.core.network.tcp.TcpClient;
import org.jetlinks.simulator.core.network.tcp.TcpOptions;
import picocli.CommandLine;
import reactor.core.publisher.Mono;

@CommandLine.Command(name="tcp", showDefaultValues=true, description={"Create TCP Benchmark"}, headerHeading="%n", sortOptions=false)
class TCPBenchMark
extends AbstractBenchmarkCommand
implements Runnable {
    @CommandLine.Mixin
    TCPCommandOptions command;
    @CommandLine.Mixin
    NetClientCommandOption common;

    TCPBenchMark() {
    }

    @Override
    protected Mono<? extends Connection> createConnection(ConnectCreateContext ctx) {
        if (null != this.common) {
            this.common.apply(this.command);
        }
        TcpOptions commandOptions = this.command.refactor(Collections.singletonMap("index", ctx.index()));
        ctx.beforeConnect(commandOptions);
        return TcpClient.connect(Global.vertx(), commandOptions);
    }

    static class TCPCommandOptions
    extends TcpOptions {
        TCPCommandOptions() {
        }

        @Override
        @CommandLine.Option(names={"--id"}, description={"ID"}, defaultValue="tcp-client-{index}", order=1)
        public void setId(String id) {
            super.setId(id);
        }

        @Override
        @CommandLine.Option(names={"-h", "--host"}, description={"host"}, order=2, defaultValue="127.0.0.1")
        public void setHost(String host) {
            super.setHost(host);
        }

        @Override
        @CommandLine.Option(names={"-p", "--port"}, description={"port"}, order=3)
        public void setPort(int port) {
            super.setPort(port);
        }

        @Override
        @CommandLine.Option(names={"--delimited"}, description={"\u4f7f\u7528\u5206\u9694\u7b26\u6765\u5904\u7406\u7c98\u62c6\u5305"}, order=4)
        public void setDelimited(String delimited) {
            super.setDelimited(delimited);
        }

        @Override
        @CommandLine.Option(names={"--fixedLength"}, description={"\u4f7f\u7528\u56fa\u5b9a\u957f\u5ea6\u6765\u5904\u7406\u7c98\u62c6\u5305"}, order=5)
        public void setFixedLength(Integer fixedLength) {
            super.setFixedLength(fixedLength);
        }

        @Override
        @CommandLine.Option(names={"--lengthField"}, description={"\u4f7f\u7528\u67d0\u4e2a\u5b57\u6bb5\u4f5c\u4e3a\u957f\u5ea6\u6765\u5904\u7406\u7c98\u62c6\u5305,\u5982: \"0,4\"\u6807\u8bc6\u4ece0\u5b57\u8282\u5f00\u59cb\u76844\u5b57\u8282\u4f5c\u4e3a\u63a5\u4e0b\u6765\u7684\u62a5\u6587\u957f\u5ea6"}, split=",", order=5)
        public void setLengthField(Integer[] lengthField) {
            super.setLengthField(lengthField);
        }
    }
}

