/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.benchmark;

import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.benchmark.BenchmarkCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.DefaultConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.benchmark.Benchmark;
import org.jetlinks.simulator.core.benchmark.ConnectCreateContext;
import picocli.CommandLine;
import reactor.core.publisher.Mono;

@CommandLine.Command(name="benchmark", hidden=true)
public abstract class AbstractBenchmarkCommand
extends AbstractCommand
implements Runnable {
    @CommandLine.Mixin
    protected BenchmarkCommand.Options options;
    protected Benchmark benchmark;

    protected String getDefaultName() {
        return this.spec.name();
    }

    protected abstract Mono<? extends Connection> createConnection(ConnectCreateContext var1);

    @Override
    public final void run() {
        String name = this.options.getName() == null ? this.getDefaultName() : this.options.getName();
        DefaultConnectionManager connectionManager = new DefaultConnectionManager();
        this.benchmark = Benchmark.create(name, this.options, connectionManager, ctx -> Mono.defer(() -> this.createConnection((ConnectCreateContext)ctx)).onErrorResume(err -> {
            this.benchmark.print("create connection[" + ctx.index() + "] error: " + ExceptionUtils.getErrorMessage(err), new Object[0]);
            return Mono.empty();
        }));
        BenchmarkCommand.addBenchmark(this.benchmark);
        this.benchmark.start();
        this.benchmark.doOnDispose(connectionManager);
        this.doAfter();
    }

    protected void doAfter() {
        this.main().getCommandLine().execute("benchmark", "stats", this.benchmark.getName());
    }
}

