/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class BinaryMapFeature
implements ValueMapFeature {
    private final String id;
    private final BiFunction<Object, Object, Object> calculator;

    public BinaryMapFeature(String type, BiFunction<Object, Object, Object> calculator) {
        this.id = FeatureId.ValueMap.of(type).getId();
        this.calculator = calculator;
    }

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        Tuple2<Function<ReactorQLRecord, Publisher<?>>, Function<ReactorQLRecord, Publisher<?>>> tuple2 = ValueMapFeature.createBinaryMapper(expression, metadata);
        Function<ReactorQLRecord, Publisher<?>> leftMapper = tuple2.getT1();
        Function<ReactorQLRecord, Publisher<?>> rightMapper = tuple2.getT2();
        return v -> Mono.zip(Mono.from((Publisher)leftMapper.apply((ReactorQLRecord)v)), Mono.from((Publisher)rightMapper.apply((ReactorQLRecord)v)), this.calculator);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

