/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.util.Recycler;
import java.util.Optional;
import java.util.function.Function;
import org.jetlinks.core.utils.RecyclableDequeue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecyclerUtils {
    private static final Logger log = LoggerFactory.getLogger(RecyclerUtils.class);

    public static <T> Recycler<T> newRecycler(Class<T> type, final Function<Recycler.Handle<T>, T> objectSupplier, int defaultRatio) {
        int maxCapacityPerThread = RecyclerUtils.getPoolConfig(type, "maxCapacityPerThread").map(Integer::parseInt).orElse(4096);
        int maxSharedCapacityFactor = RecyclerUtils.getPoolConfig(type, "maxSharedCapacityFactor").map(Integer::parseInt).orElse(2);
        int maxDelayedQueuesPerThread = RecyclerUtils.getPoolConfig(type, "maxDelayedQueuesPerThread").map(Integer::parseInt).orElse(Runtime.getRuntime().availableProcessors() * 2);
        int ratio = RecyclerUtils.getPoolConfig(type, "ratio").map(Integer::parseInt).orElse(defaultRatio);
        if (log.isDebugEnabled()) {
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxCapacityPerThread"), (Object)maxCapacityPerThread);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxSharedCapacityFactor"), (Object)maxSharedCapacityFactor);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxDelayedQueuesPerThread"), (Object)maxDelayedQueuesPerThread);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "ratio"), (Object)ratio);
        }
        return new Recycler<T>(maxCapacityPerThread, maxSharedCapacityFactor, ratio, maxDelayedQueuesPerThread){

            @Override
            protected T newObject(Recycler.Handle<T> handle) {
                return objectSupplier.apply(handle);
            }
        };
    }

    public static <T> Recycler<T> newRecycler(Class<T> type, Function<Recycler.Handle<T>, T> objectSupplier) {
        return RecyclerUtils.newRecycler(type, objectSupplier, 8);
    }

    private static Optional<String> getPoolConfig(Class<?> type, String key) {
        return Optional.ofNullable(System.getProperty(RecyclerUtils.getConfigName(type, key)));
    }

    private static String getConfigName(Class<?> type, String key) {
        return (type.getName() + ".pool." + key).replace("$$", ".").replace("$", ".");
    }

    public static <T> RecyclableDequeue<T> dequeue() {
        return RecyclableDequeue.newInstance();
    }
}

