/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace.data;

import com.google.common.collect.Maps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.trace.data.SpanEventDataInfo;
import org.jetlinks.core.utils.SerializeUtils;

public class SpanDataInfo
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private String app;
    private String name;
    private String traceId;
    private long startWithNanos;
    private long endWithNanos;
    private Map<String, Object> attributes;
    private List<SpanEventDataInfo> events;

    public static SpanDataInfo of(SpanData data) {
        return new SpanDataInfo().with(data);
    }

    public SpanDataInfo with(SpanData data) {
        List eventData;
        this.app = data.getInstrumentationLibraryInfo().getName();
        this.name = data.getName();
        this.traceId = data.getTraceId();
        this.startWithNanos = data.getStartEpochNanos();
        this.endWithNanos = data.getEndEpochNanos();
        Attributes attr = data.getAttributes();
        if (!attr.isEmpty()) {
            this.attributes = Maps.newHashMapWithExpectedSize(attr.size());
            attr.forEach((k, v) -> this.attributes.put(k.getKey(), v));
        }
        if (CollectionUtils.isNotEmpty(eventData = data.getEvents())) {
            this.events = new ArrayList<SpanEventDataInfo>();
            for (EventData eventDatum : eventData) {
                this.events.add(SpanEventDataInfo.of(eventDatum));
            }
        }
        return this;
    }

    public Optional<SpanEventDataInfo> getEvent(String name) {
        if (this.events == null) {
            return Optional.empty();
        }
        for (SpanEventDataInfo eventInfo : this.events) {
            if (!Objects.equals(name, eventInfo.getName())) continue;
            return Optional.of(eventInfo);
        }
        return Optional.empty();
    }

    public <T> Optional<T> getAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.get(key));
    }

    public <T> Optional<T> getAttribute(AttributeKey<T> key) {
        return this.getAttribute(key.getKey());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.app);
        out.writeUTF(this.name);
        out.writeUTF(this.traceId);
        out.writeLong(this.startWithNanos);
        out.writeLong(this.endWithNanos);
        SerializeUtils.writeKeyValue(this.attributes, out);
        if (this.events == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.events.size());
            for (SpanEventDataInfo event : this.events) {
                event.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.app = in.readUTF();
        this.name = in.readUTF();
        this.traceId = in.readUTF();
        this.startWithNanos = in.readLong();
        this.endWithNanos = in.readLong();
        this.attributes = SerializeUtils.readMap(in, Maps::newHashMapWithExpectedSize);
        int eventSize = in.readInt();
        if (eventSize > 0) {
            this.events = new ArrayList<SpanEventDataInfo>(eventSize);
            for (int i2 = 0; i2 < eventSize; ++i2) {
                SpanEventDataInfo dataInfo = new SpanEventDataInfo();
                dataInfo.readExternal(in);
                this.events.add(dataInfo);
            }
        }
    }

    public String getApp() {
        return this.app;
    }

    public String getName() {
        return this.name;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public long getStartWithNanos() {
        return this.startWithNanos;
    }

    public long getEndWithNanos() {
        return this.endWithNanos;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<SpanEventDataInfo> getEvents() {
        return this.events;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setStartWithNanos(long startWithNanos) {
        this.startWithNanos = startWithNanos;
    }

    public void setEndWithNanos(long endWithNanos) {
        this.endWithNanos = endWithNanos;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setEvents(List<SpanEventDataInfo> events) {
        this.events = events;
    }
}

