/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.trace.data.SpanDataInfo;
import org.jetlinks.core.utils.StringBuilderUtils;
import reactor.core.publisher.Mono;

public class EventBusSpanExporter
implements SpanExporter {
    private final EventBus eventBus;
    private static final Codec<SpanDataInfo> codec = Codecs.lookup(SpanDataInfo.class);

    public CompletableResultCode export(Collection<SpanData> spans) {
        for (SpanData span : spans) {
            this.doPublish(span).subscribe();
        }
        return CompletableResultCode.ofSuccess();
    }

    Mono<Void> doPublish(SpanData data) {
        String topic = StringBuilderUtils.buildString(data, (_data, builder) -> {
            builder.append("/trace/").append(_data.getInstrumentationLibraryInfo().getName());
            if (!_data.getName().startsWith("/")) {
                builder.append("/");
            }
            builder.append(_data.getName());
        });
        return this.eventBus.publish(topic, codec, SpanDataInfo.of(data)).then();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    private EventBusSpanExporter(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public static EventBusSpanExporter create(EventBus eventBus) {
        return new EventBusSpanExporter(eventBus);
    }
}

