/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things.relation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;

public class RelationSpec {
    public static final String OPTION_REVERSE = "reverse";
    private String objectType;
    private String relation;
    private Map<String, Object> options;
    private RelationSpec next;

    @JsonIgnore
    public boolean isReverse() {
        return this.options != null && Boolean.TRUE.equals(this.options.get(OPTION_REVERSE));
    }

    public void reverse(boolean reverse) {
        this.option(OPTION_REVERSE, reverse);
    }

    public String toString() {
        String rel = this.relation;
        if (this.options != null) {
            rel = rel + "$" + String.join((CharSequence)"$", this.options.keySet());
        }
        String expr = rel + "@" + this.objectType;
        if (this.next != null) {
            expr = expr + ":" + this.next;
        }
        return expr;
    }

    public RelationSpec option(String key, Object value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(key, value);
        return this;
    }

    public static RelationSpec of(Object spec) {
        if (spec instanceof RelationSpec) {
            return (RelationSpec)spec;
        }
        if (spec instanceof String) {
            return RelationSpec.parse(String.valueOf(spec));
        }
        return FastBeanCopier.copy(spec, new RelationSpec(), new String[0]);
    }

    public static RelationSpec parse(String expr) {
        String[] objects = expr.split(":", 2);
        String[] first = objects[0].split("@");
        if (first.length != 2) {
            throw new UnsupportedOperationException("unsupported expression :" + objects[0]);
        }
        RelationSpec spec = new RelationSpec();
        String relation = first[0];
        if (relation.contains("$")) {
            String[] rel = relation.split("\\$", 2);
            relation = rel[0];
            for (int i2 = 1; i2 < rel.length; ++i2) {
                String opt = rel[i2];
                spec.option(opt, true);
            }
        }
        spec.relation = relation;
        spec.objectType = first[1];
        if (objects.length == 2) {
            spec.next = RelationSpec.parse(objects[1]);
        }
        return spec;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getRelation() {
        return this.relation;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public RelationSpec getNext() {
        return this.next;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setNext(RelationSpec next) {
        this.next = next;
    }
}

