/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingInfo;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingTemplateInfo;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.core.things.ThingsRegistrySupport;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class DefaultThingsRegistry
implements ThingsRegistry {
    private final List<ThingsRegistrySupport> supports = new CopyOnWriteArrayList<ThingsRegistrySupport>();

    public DefaultThingsRegistry() {
    }

    public DefaultThingsRegistry(Iterable<ThingsRegistrySupport> supports) {
        for (ThingsRegistrySupport support : supports) {
            this.supports.add(support);
        }
    }

    public Disposable addSupport(ThingsRegistrySupport support) {
        this.supports.add(support);
        return () -> this.supports.remove(support);
    }

    protected <ARG, R> R findSupport(String thingType, ARG arg, Function3<ThingsRegistrySupport, String, ARG, R> computer, Supplier<R> defaultGetter) {
        for (ThingsRegistrySupport support : this.supports) {
            if (!support.isSupported(thingType)) continue;
            return computer.apply(support, thingType, arg);
        }
        return defaultGetter.get();
    }

    @Override
    public Mono<Thing> getThing(@Nonnull String thingType, @Nonnull String thingId) {
        return this.findSupport(thingType, thingId, ThingsRegistry::getThing, Mono::empty);
    }

    @Override
    public Mono<ThingTemplate> getTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        return this.findSupport(thingType, templateId, ThingsRegistry::getTemplate, Mono::empty);
    }

    @Override
    public Mono<Thing> register(@Nonnull String thingType, @Nonnull ThingInfo info) {
        return this.findSupport(thingType, info, ThingsRegistry::register, Mono::empty);
    }

    @Override
    public Mono<Void> unregisterThing(@Nonnull String thingType, @Nonnull String thingId) {
        return this.findSupport(thingType, thingId, ThingsRegistry::unregisterThing, Mono::empty);
    }

    @Override
    public Mono<ThingTemplate> register(@Nonnull String thingType, @Nonnull ThingTemplateInfo templateInfo) {
        return this.findSupport(thingType, templateInfo, ThingsRegistry::register, Mono::empty);
    }

    @Override
    public Mono<Void> unregisterTemplate(@Nonnull String thingType, @Nonnull String thingId) {
        return this.findSupport(thingType, thingId, ThingsRegistry::unregisterTemplate, Mono::empty);
    }
}

