/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.firmware;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.utils.SerializeUtils;

public class RequestFirmwareMessageReply
extends CommonDeviceMessageReply<RequestFirmwareMessageReply> {
    private String url;
    private String version;
    private Map<String, Object> parameters;
    private String sign;
    private String signMethod;
    private String firmwareId;
    private long size;

    @Override
    public MessageType getMessageType() {
        return MessageType.REQUEST_FIRMWARE_REPLY;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.url, out);
        SerializeUtils.writeNullableUTF(this.version, out);
        SerializeUtils.writeNullableUTF(this.sign, out);
        SerializeUtils.writeNullableUTF(this.signMethod, out);
        SerializeUtils.writeNullableUTF(this.firmwareId, out);
        out.writeLong(this.size);
        SerializeUtils.writeKeyValue(this.parameters, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.url = SerializeUtils.readNullableUTF(in);
        this.version = SerializeUtils.readNullableUTF(in);
        this.sign = SerializeUtils.readNullableUTF(in);
        this.signMethod = SerializeUtils.readNullableUTF(in);
        this.firmwareId = SerializeUtils.readNullableUTF(in);
        this.size = in.readLong();
        this.parameters = SerializeUtils.readMap(in, Maps::newHashMapWithExpectedSize);
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getSign() {
        return this.sign;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public String getFirmwareId() {
        return this.firmwareId;
    }

    public long getSize() {
        return this.size;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setFirmwareId(String firmwareId) {
        this.firmwareId = firmwareId;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

