/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.incubator.quic.QuicConnection;
import reactor.netty.incubator.quic.QuicInitialSettingsSpec;
import reactor.netty.incubator.quic.QuicServer;
import reactor.netty.incubator.quic.QuicTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.annotation.Nullable;

public final class QuicServerConfig
extends QuicTransportConfig<QuicServerConfig> {
    public static final String QUIC_SERVER_PREFIX = "reactor.netty.quic.server";
    static final QuicConnectionIdGenerator DEFAULT_CONNECTION_ID_ADDRESS_GENERATOR = QuicConnectionIdGenerator.randomGenerator();
    QuicConnectionIdGenerator connectionIdAddressGenerator;
    Consumer<? super QuicConnection> doOnConnection;
    QuicTokenHandler tokenHandler;
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(QuicServer.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    QuicServerConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> streamOptions, Supplier<? extends SocketAddress> bindAddress) {
        super(options, streamOptions, bindAddress);
        this.connectionIdAddressGenerator = DEFAULT_CONNECTION_ID_ADDRESS_GENERATOR;
    }

    QuicServerConfig(QuicServerConfig parent) {
        super(parent);
        this.connectionIdAddressGenerator = parent.connectionIdAddressGenerator;
        this.doOnConnection = parent.doOnConnection;
        this.tokenHandler = parent.tokenHandler;
    }

    public QuicConnectionIdGenerator connectionIdAddressGenerator() {
        return this.connectionIdAddressGenerator;
    }

    @Nullable
    public Consumer<? super QuicConnection> doOnConnection() {
        return this.doOnConnection;
    }

    @Nullable
    public QuicTokenHandler tokenHandler() {
        return this.tokenHandler;
    }

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnConnection() == null) {
            return super.defaultConnectionObserver();
        }
        return super.defaultConnectionObserver().then(new QuicServerDoOnConnection(this.channelGroup(), this.doOnConnection()));
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerQuicServerMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelInitializer<Channel> parentChannelInitializer() {
        return new ParentChannelInitializer(this);
    }

    static final class QuicServerDoOnConnection
    implements ConnectionObserver {
        final ChannelGroup channelGroup;
        final Consumer<? super QuicConnection> doOnConnection;

        QuicServerDoOnConnection(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super QuicConnection> doOnConnection) {
            this.channelGroup = channelGroup;
            this.doOnConnection = doOnConnection;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add(connection.channel());
                return;
            }
            if (this.doOnConnection != null && newState == ConnectionObserver.State.CONFIGURED) {
                try {
                    this.doOnConnection.accept((QuicConnection)connection);
                }
                catch (Throwable t) {
                    QuicTransportConfig.log.error(ReactorNetty.format(connection.channel(), ""), t);
                    connection.channel().close();
                }
            }
        }
    }

    static final class ParentChannelInitializer
    extends ChannelInitializer<Channel> {
        final long ackDelayExponent;
        final boolean activeMigration;
        final Map<AttributeKey<?>, ?> attributes;
        final QuicCongestionControlAlgorithm congestionControlAlgorithm;
        final QuicConnectionIdGenerator connectionIdAddressGenerator;
        final boolean grease;
        final boolean hystart;
        final Duration idleTimeout;
        final QuicInitialSettingsSpec initialSettings;
        final int localConnectionIdLength;
        final ChannelHandler loggingHandler;
        final Duration maxAckDelay;
        final long maxRecvUdpPayloadSize;
        final long maxSendUdpPayloadSize;
        final Map<ChannelOption<?>, ?> options;
        final ChannelInitializer<Channel> quicChannelInitializer;
        final int recvQueueLen;
        final int sendQueueLen;
        final Map<AttributeKey<?>, ?> streamAttrs;
        final ConnectionObserver streamObserver;
        final Map<ChannelOption<?>, ?> streamOptions;
        final Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider;
        final QuicTokenHandler tokenHandler;

        ParentChannelInitializer(QuicServerConfig config) {
            this.ackDelayExponent = config.ackDelayExponent;
            this.activeMigration = config.activeMigration;
            this.attributes = config.attributes();
            this.congestionControlAlgorithm = config.congestionControlAlgorithm;
            this.connectionIdAddressGenerator = config.connectionIdAddressGenerator;
            this.grease = config.grease;
            this.hystart = config.hystart;
            this.idleTimeout = config.idleTimeout;
            this.initialSettings = config.initialSettings;
            this.localConnectionIdLength = config.localConnectionIdLength;
            this.loggingHandler = config.loggingHandler();
            this.maxAckDelay = config.maxAckDelay;
            this.maxRecvUdpPayloadSize = config.maxRecvUdpPayloadSize;
            this.maxSendUdpPayloadSize = config.maxSendUdpPayloadSize;
            this.options = config.options();
            ConnectionObserver observer = config.defaultConnectionObserver().then(config.connectionObserver());
            this.quicChannelInitializer = config.channelInitializer(observer, null, true);
            this.recvQueueLen = config.recvQueueLen;
            this.sendQueueLen = config.sendQueueLen;
            this.streamAttrs = config.streamAttrs;
            this.streamObserver = config.streamObserver.then(new QuicTransportConfig.QuicStreamChannelObserver(config.streamHandler));
            this.streamOptions = config.streamOptions;
            this.sslEngineProvider = config.sslEngineProvider;
            this.tokenHandler = config.tokenHandler;
        }

        @Override
        protected void initChannel(Channel channel) {
            QuicServerCodecBuilder quicServerCodecBuilder = new QuicServerCodecBuilder();
            ((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)quicServerCodecBuilder.ackDelayExponent(this.ackDelayExponent)).activeMigration(this.activeMigration)).congestionControlAlgorithm(this.congestionControlAlgorithm)).connectionIdAddressGenerator(this.connectionIdAddressGenerator).grease(this.grease)).hystart(this.hystart)).initialMaxData(this.initialSettings.maxData)).initialMaxStreamDataBidirectionalLocal(this.initialSettings.maxStreamDataBidirectionalLocal)).initialMaxStreamDataBidirectionalRemote(this.initialSettings.maxStreamDataBidirectionalRemote)).initialMaxStreamDataUnidirectional(this.initialSettings.maxStreamDataUnidirectional)).initialMaxStreamsBidirectional(this.initialSettings.maxStreamsBidirectional)).initialMaxStreamsUnidirectional(this.initialSettings.maxStreamsUnidirectional)).localConnectionIdLength(this.localConnectionIdLength)).maxAckDelay(this.maxAckDelay.toMillis(), TimeUnit.MILLISECONDS)).maxRecvUdpPayloadSize(this.maxRecvUdpPayloadSize)).maxSendUdpPayloadSize(this.maxSendUdpPayloadSize)).sslEngineProvider(this.sslEngineProvider);
            if (this.recvQueueLen > 0 && this.sendQueueLen > 0) {
                quicServerCodecBuilder.datagram(this.recvQueueLen, this.sendQueueLen);
            }
            if (this.idleTimeout != null) {
                quicServerCodecBuilder.maxIdleTimeout(this.idleTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            if (this.tokenHandler != null) {
                quicServerCodecBuilder.tokenHandler(this.tokenHandler);
            }
            ParentChannelInitializer.attributes(quicServerCodecBuilder, this.attributes);
            ParentChannelInitializer.channelOptions(quicServerCodecBuilder, this.options);
            ParentChannelInitializer.streamAttributes(quicServerCodecBuilder, this.streamAttrs);
            ParentChannelInitializer.streamChannelOptions(quicServerCodecBuilder, this.streamOptions);
            quicServerCodecBuilder.handler(this.quicChannelInitializer).streamHandler(QuicTransportConfig.streamChannelInitializer(this.loggingHandler, this.streamObserver, true));
            if (this.loggingHandler != null) {
                channel.pipeline().addLast(this.loggingHandler);
            }
            channel.pipeline().addLast(quicServerCodecBuilder.build());
        }

        static void attributes(QuicServerCodecBuilder quicServerCodecBuilder, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                quicServerCodecBuilder.attr(e.getKey(), e.getValue());
            }
        }

        static void channelOptions(QuicServerCodecBuilder quicServerCodecBuilder, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                quicServerCodecBuilder.option(e.getKey(), e.getValue());
            }
        }

        static void streamAttributes(QuicServerCodecBuilder quicServerCodecBuilder, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                quicServerCodecBuilder.streamAttr(e.getKey(), e.getValue());
            }
        }

        static void streamChannelOptions(QuicServerCodecBuilder quicServerCodecBuilder, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                quicServerCodecBuilder.streamOption(e.getKey(), e.getValue());
            }
        }
    }

    static final class MicrometerQuicServerMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerQuicServerMetricsRecorder INSTANCE = new MicrometerQuicServerMetricsRecorder();

        MicrometerQuicServerMetricsRecorder() {
            super(QuicServerConfig.QUIC_SERVER_PREFIX, "quic");
        }
    }
}

