/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.synchronoss.cloud.nio.multipart.MultipartContext;
import org.synchronoss.cloud.nio.multipart.util.IOUtils;
import org.synchronoss.cloud.nio.multipart.util.ParameterParser;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class MultipartUtils {
    public static final byte DASH = 45;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte[] HEADER_DELIMITER = new byte[]{13, 10, 13, 10};
    public static final String MULTIPART = "multipart/";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-transfer-encoding";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String TEXT_PLAIN = "text/plain";

    private MultipartUtils() {
    }

    public static boolean isMultipart(String contentTypeHeaderValue) {
        return contentTypeHeaderValue != null && contentTypeHeaderValue.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public static boolean hasMultipartContentType(Map<String, List<String>> headers2) {
        return MultipartUtils.isMultipart(MultipartUtils.getContentType(headers2));
    }

    public static String getContentType(Map<String, List<String>> headers2) {
        return MultipartUtils.getHeader(CONTENT_TYPE, headers2);
    }

    public static long getContentLength(Map<String, List<String>> headers2) {
        long contentLength = -1L;
        String contentLengthHeaderValue = MultipartUtils.getHeader(CONTENT_LENGTH, headers2);
        if (contentLengthHeaderValue != null && contentLengthHeaderValue.length() > 0) {
            try {
                contentLength = Long.parseLong(contentLengthHeaderValue);
            }
            catch (Exception e) {
                contentLength = -1L;
            }
        }
        return contentLength;
    }

    public static String getCharEncoding(Map<String, List<String>> headers2) {
        String contentType2 = MultipartUtils.getHeader(CONTENT_TYPE, headers2);
        if (contentType2 != null) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentType2, ';');
            return params.get("charset");
        }
        return null;
    }

    public static List<String> getHeaders(String headerName, Map<String, List<String>> headers2) {
        return headers2.get(headerName.toLowerCase());
    }

    public static String getHeader(String headerName, Map<String, List<String>> headers2) {
        List<String> headerValues = MultipartUtils.getHeaders(headerName, headers2);
        if (headerValues == null || headerValues.size() == 0) {
            return null;
        }
        return headerValues.get(0);
    }

    public static boolean isFormField(Map<String, List<String>> headers2, MultipartContext context) {
        boolean isTextPlain;
        boolean hasFieldName;
        boolean hasFileName;
        boolean bl = hasFileName = MultipartUtils.getFileName(headers2) != null;
        if (hasFileName) {
            return false;
        }
        boolean bl2 = hasFieldName = MultipartUtils.getFieldName(headers2) != null;
        if (!hasFieldName) {
            return false;
        }
        String contentType2 = MultipartUtils.getContentType(headers2);
        boolean isMultipartFormData = context.getContentType().startsWith(MULTIPART_FORM_DATA);
        if (!isMultipartFormData) {
            return false;
        }
        boolean bl3 = isTextPlain = contentType2 == null || contentType2.startsWith(TEXT_PLAIN);
        return isTextPlain;
    }

    public static String readFormParameterValue(StreamStorage streamStorage, Map<String, List<String>> headers2) {
        try {
            return IOUtils.inputStreamAsString(streamStorage.getInputStream(), MultipartUtils.getCharEncoding(headers2));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read the form parameter value", e);
        }
    }

    public static String getFileName(Map<String, List<String>> headers2) {
        String contentDispositionLc;
        String contentDisposition = MultipartUtils.getHeader(CONTENT_DISPOSITION, headers2);
        String fileName = null;
        if (contentDisposition != null && ((contentDispositionLc = contentDisposition.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || contentDispositionLc.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    public static String getFieldName(Map<String, List<String>> headers2) {
        String contentDisposition = MultipartUtils.getHeader(CONTENT_DISPOSITION, headers2);
        String fieldName = null;
        if (contentDisposition != null && contentDisposition.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    public static boolean isContentTransferEncodingBase64Encoded(Map<String, List<String>> partHeaders) {
        String contentEncoding = MultipartUtils.getHeader(CONTENT_TRANSFER_ENCODING, partHeaders);
        return contentEncoding != null && "base64".equalsIgnoreCase(contentEncoding);
    }

    public static byte[] getBoundary(String contentType2) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType2, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }
}

