/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.Configurable;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.config.StorageConfigurable;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingMetadataCodec;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsConfigKeys;
import reactor.core.publisher.Mono;

class DefaultThingTemplate
implements ThingTemplate,
StorageConfigurable {
    private final String id;
    private final Mono<ConfigStorage> storageMono;
    private final Mono<ThingMetadata> metadataMono;
    private volatile long lastMetadataTime = -1L;
    private volatile ThingMetadata metadataCache;
    private final ThingMetadataCodec metadataCodec;

    public DefaultThingTemplate(ThingType thingType, String id, ConfigStorageManager storageManager, ThingMetadataCodec metadataCodec) {
        this.id = id;
        this.storageMono = storageManager.getStorage("thing-template:" + thingType.getId() + ":" + id);
        this.metadataCodec = metadataCodec;
        this.metadataMono = this.getConfig(ThingsConfigKeys.lastMetadataTimeKey).flatMap(i2 -> {
            if (i2.equals(this.lastMetadataTime) && this.metadataCache != null) {
                return Mono.just(this.metadataCache);
            }
            this.lastMetadataTime = i2;
            return this.getConfig(DeviceConfigKey.metadata).flatMap(metadataCodec::decode).doOnNext(metadata -> {
                this.metadataCache = metadata;
            });
        });
    }

    @Override
    public Mono<? extends Configurable> getParent() {
        return Mono.empty();
    }

    @Override
    public Mono<ConfigStorage> getReactiveStorage() {
        return this.storageMono;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Mono<ThingMetadata> getMetadata() {
        return this.metadataMono;
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(DeviceConfigKey.metadata.getKey(), metadata);
        return this.setConfigs(configs);
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        HashMap<String, Object> configs = new HashMap<String, Object>(conf);
        if (conf.containsKey(DeviceConfigKey.metadata.getKey())) {
            this.lastMetadataTime = System.currentTimeMillis();
            configs.put(ThingsConfigKeys.lastMetadataTimeKey.getKey(), this.lastMetadataTime);
            return StorageConfigurable.super.setConfigs(configs).doOnNext(suc -> {
                this.metadataCache = null;
            }).thenReturn(true);
        }
        return StorageConfigurable.super.setConfigs(configs);
    }

    @Override
    public Mono<Boolean> updateMetadata(ThingMetadata metadata) {
        return this.metadataCodec.encode(metadata).flatMap(this::updateMetadata);
    }
}

