/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeConnectionManager
implements ConnectionManager {
    private final Collection<ConnectionManager> all;

    @Override
    public long getConnectionSize() {
        long count = 0L;
        for (ConnectionManager connectionManager : this.all) {
            count += connectionManager.getConnectionSize();
        }
        return count;
    }

    @Override
    public Flux<Connection> getConnections() {
        return Flux.fromIterable(this.all).flatMap(ConnectionManager::getConnections);
    }

    @Override
    public Mono<Connection> getConnection(String id) {
        return Flux.fromIterable(this.all).flatMap(manager -> manager.getConnection(id)).take(1L).singleOrEmpty();
    }

    @Override
    public Optional<Connection> getConnectionNow(String id) {
        for (ConnectionManager connectionManager : this.all) {
            Optional<Connection> opt = connectionManager.getConnectionNow(id);
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }

    @Override
    public Flux<Connection> findConnection(String ql) {
        return Flux.fromIterable(this.all).flatMap(c -> c.findConnection(ql));
    }

    @Override
    public Flux<Connection> randomConnection(int size) {
        return Flux.concat(Flux.fromIterable(this.all).map(c -> c.randomConnection(size))).take(size);
    }

    @Override
    public ConnectionManager addConnection(Connection connection) {
        Iterator<ConnectionManager> iterator = this.all.iterator();
        if (iterator.hasNext()) {
            ConnectionManager connectionManager = iterator.next();
            connectionManager.addConnection(connection);
            return this;
        }
        return this;
    }

    @Override
    public void dispose() {
        for (ConnectionManager connectionManager : this.all) {
            connectionManager.dispose();
        }
    }

    public CompositeConnectionManager(Collection<ConnectionManager> all) {
        this.all = all;
    }
}

