/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.ChannelOption;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.util.AttributeKey;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.incubator.quic.QuicInbound;
import reactor.netty.incubator.quic.QuicInitialSettingsSpec;
import reactor.netty.incubator.quic.QuicOutbound;
import reactor.netty.incubator.quic.QuicTransportConfig;
import reactor.netty.transport.Transport;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

abstract class QuicTransport<T extends Transport<T, CONF>, CONF extends QuicTransportConfig<CONF>>
extends Transport<T, CONF> {
    static final Logger log = Loggers.getLogger(QuicTransport.class);

    QuicTransport() {
    }

    public final T ackDelayExponent(long ackDelayExponent) {
        if (ackDelayExponent < 0L) {
            throw new IllegalArgumentException("ackDelayExponent must be positive or zero");
        }
        if (ackDelayExponent == ((QuicTransportConfig)this.configuration()).ackDelayExponent) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).ackDelayExponent = ackDelayExponent;
        return dup;
    }

    public final T activeMigration(boolean enable) {
        if (enable == ((QuicTransportConfig)this.configuration()).activeMigration) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).activeMigration = enable;
        return dup;
    }

    public final T congestionControlAlgorithm(QuicCongestionControlAlgorithm congestionControlAlgorithm) {
        Objects.requireNonNull(congestionControlAlgorithm, "congestionControlAlgorithm");
        if (congestionControlAlgorithm == ((QuicTransportConfig)this.configuration()).congestionControlAlgorithm) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).congestionControlAlgorithm = congestionControlAlgorithm;
        return dup;
    }

    public final T datagram(int recvQueueLen, int sendQueueLen) {
        if (recvQueueLen < 1) {
            throw new IllegalArgumentException("recvQueueLen must be positive");
        }
        if (sendQueueLen < 1) {
            throw new IllegalArgumentException("sendQueueLen must be positive");
        }
        if (recvQueueLen == ((QuicTransportConfig)this.configuration()).recvQueueLen && sendQueueLen == ((QuicTransportConfig)this.configuration()).sendQueueLen) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).recvQueueLen = recvQueueLen;
        ((QuicTransportConfig)((Transport)dup).configuration()).sendQueueLen = sendQueueLen;
        return dup;
    }

    public final T doOnBind(Consumer<? super CONF> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        Object dup = this.duplicate();
        Consumer current = ((QuicTransportConfig)((Transport)dup).configuration()).doOnBind;
        ((QuicTransportConfig)((Transport)dup).configuration()).doOnBind = current == null ? doOnBind : current.andThen(doOnBind);
        return dup;
    }

    public final T doOnBound(Consumer<? super Connection> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        Object dup = this.duplicate();
        Consumer<? super Connection> current = ((QuicTransportConfig)((Transport)dup).configuration()).doOnBound;
        ((QuicTransportConfig)((Transport)dup).configuration()).doOnBound = current == null ? doOnBound : current.andThen(doOnBound);
        return dup;
    }

    public final T doOnUnbound(Consumer<? super Connection> doOnUnbound) {
        Objects.requireNonNull(doOnUnbound, "doOnUnbound");
        Object dup = this.duplicate();
        Consumer<? super Connection> current = ((QuicTransportConfig)((Transport)dup).configuration()).doOnUnbound;
        ((QuicTransportConfig)((Transport)dup).configuration()).doOnUnbound = current == null ? doOnUnbound : current.andThen(doOnUnbound);
        return dup;
    }

    public final T grease(boolean enable) {
        if (enable == ((QuicTransportConfig)this.configuration()).grease) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).grease = enable;
        return dup;
    }

    public final T handleStream(BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler) {
        Objects.requireNonNull(streamHandler, "streamHandler");
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).streamHandler = streamHandler;
        return dup;
    }

    public final T hystart(boolean enable) {
        if (enable == ((QuicTransportConfig)this.configuration()).hystart) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).hystart = enable;
        return dup;
    }

    public final T idleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        if (idleTimeout.equals(((QuicTransportConfig)this.configuration()).idleTimeout)) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).idleTimeout = idleTimeout;
        return dup;
    }

    public final T initialSettings(Consumer<QuicInitialSettingsSpec.Builder> initialSettings) {
        Objects.requireNonNull(initialSettings, "initialSettings");
        QuicInitialSettingsSpec.Build builder = new QuicInitialSettingsSpec.Build();
        initialSettings.accept(builder);
        QuicInitialSettingsSpec settings = builder.build();
        if (settings.equals(((QuicTransportConfig)this.configuration()).initialSettings)) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).initialSettings = settings;
        return dup;
    }

    public final T localConnectionIdLength(int localConnectionIdLength) {
        if (localConnectionIdLength < 0 || localConnectionIdLength > 20) {
            throw new IllegalArgumentException("localConnectionIdLength must be between zero and 20");
        }
        if (localConnectionIdLength == ((QuicTransportConfig)this.configuration()).localConnectionIdLength) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).localConnectionIdLength = localConnectionIdLength;
        return dup;
    }

    public final T maxAckDelay(Duration maxAckDelay) {
        Objects.requireNonNull(maxAckDelay, "maxAckDelay");
        if (maxAckDelay.equals(((QuicTransportConfig)this.configuration()).maxAckDelay)) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).maxAckDelay = maxAckDelay;
        return dup;
    }

    public final T maxRecvUdpPayloadSize(long maxRecvUdpPayloadSize) {
        if (maxRecvUdpPayloadSize < 0L) {
            throw new IllegalArgumentException("maxUdpPayloadSize must be positive or zero");
        }
        if (maxRecvUdpPayloadSize == ((QuicTransportConfig)this.configuration()).maxRecvUdpPayloadSize) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).maxRecvUdpPayloadSize = maxRecvUdpPayloadSize;
        return dup;
    }

    public final T maxSendUdpPayloadSize(long maxSendUdpPayloadSize) {
        if (maxSendUdpPayloadSize < 0L) {
            throw new IllegalArgumentException("maxUdpPayloadSize must be positive or zero");
        }
        if (maxSendUdpPayloadSize == ((QuicTransportConfig)this.configuration()).maxSendUdpPayloadSize) {
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).maxSendUdpPayloadSize = maxSendUdpPayloadSize;
        return dup;
    }

    public final T secure(QuicSslContext sslContext) {
        Objects.requireNonNull(sslContext, "sslContext");
        return this.secure((QuicChannel quicChannel) -> sslContext.newEngine(quicChannel.alloc()));
    }

    public final T secure(Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider) {
        Objects.requireNonNull(sslEngineProvider, "sslEngineProvider");
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).sslEngineProvider = sslEngineProvider;
        return dup;
    }

    public final <A> T streamAttr(AttributeKey<A> key, @Nullable A value) {
        Objects.requireNonNull(key, "key");
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).streamAttrs = QuicTransportConfig.updateMap(((QuicTransportConfig)this.configuration()).streamAttrs, key, value);
        return dup;
    }

    public T streamObserve(ConnectionObserver observer) {
        Objects.requireNonNull(observer, "observer");
        Object dup = this.duplicate();
        ConnectionObserver current = ((QuicTransportConfig)this.configuration()).streamObserver;
        ((QuicTransportConfig)((Transport)dup).configuration()).streamObserver = current == null ? observer : current.then(observer);
        return dup;
    }

    public final <A> T streamOption(ChannelOption<A> key, @Nullable A value) {
        Objects.requireNonNull(key, "key");
        if (ChannelOption.AUTO_READ == key) {
            if (value instanceof Boolean && Boolean.TRUE.equals(value)) {
                log.error("ChannelOption.AUTO_READ is configured to be [false], it cannot be set to [true]");
            }
            QuicTransport dup = this;
            return (T)dup;
        }
        Object dup = this.duplicate();
        ((QuicTransportConfig)((Transport)dup).configuration()).streamOptions = QuicTransportConfig.updateMap(((QuicTransportConfig)this.configuration()).streamOptions, key, value);
        return dup;
    }

    public final Mono<Void> warmup() {
        return Mono.fromRunnable(() -> ((QuicTransportConfig)this.configuration()).eventLoopGroup());
    }
}

