/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.incubator.quic.QuicConnection;
import reactor.netty.incubator.quic.QuicServerBind;
import reactor.netty.incubator.quic.QuicServerConfig;
import reactor.netty.incubator.quic.QuicTransport;
import reactor.netty.transport.AddressUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class QuicServer
extends QuicTransport<QuicServer, QuicServerConfig> {
    static final Logger log = Loggers.getLogger(QuicServer.class);

    public static QuicServer create() {
        return QuicServerBind.INSTANCE;
    }

    public abstract Mono<? extends Connection> bind();

    public final Connection bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final Connection bindNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull(this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("QuicServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final QuicServer connectionIdAddressGenerator(QuicConnectionIdGenerator connectionIdAddressGenerator) {
        Objects.requireNonNull(connectionIdAddressGenerator, "connectionIdAddressGenerator");
        QuicServer dup = (QuicServer)this.duplicate();
        ((QuicServerConfig)dup.configuration()).connectionIdAddressGenerator = connectionIdAddressGenerator;
        return dup;
    }

    public final QuicServer doOnConnection(Consumer<? super QuicConnection> doOnConnection) {
        Objects.requireNonNull(doOnConnection, "doOnConnected");
        QuicServer dup = (QuicServer)this.duplicate();
        Consumer<? super QuicConnection> current = ((QuicServerConfig)this.configuration()).doOnConnection;
        ((QuicServerConfig)dup.configuration()).doOnConnection = current == null ? doOnConnection : current.andThen(doOnConnection);
        return dup;
    }

    public final QuicServer host(String host) {
        return (QuicServer)this.bindAddress(() -> AddressUtils.updateHost(((QuicServerConfig)this.configuration()).bindAddress(), host));
    }

    public final QuicServer port(int port) {
        return (QuicServer)this.bindAddress(() -> AddressUtils.updatePort(((QuicServerConfig)this.configuration()).bindAddress(), port));
    }

    public final QuicServer tokenHandler(QuicTokenHandler tokenHandler) {
        Objects.requireNonNull(tokenHandler, "tokenHandler");
        QuicServer dup = (QuicServer)this.duplicate();
        ((QuicServerConfig)dup.configuration()).tokenHandler = tokenHandler;
        return dup;
    }
}

