/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigDecimal;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

public class MonoAverageBigDecimal<T>
extends MonoFromFluxOperator<T, BigDecimal>
implements Fuseable {
    private final Function<? super T, ? extends Number> mapping;

    MonoAverageBigDecimal(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    @Override
    public void subscribe(CoreSubscriber<? super BigDecimal> actual) {
        this.source.subscribe(new AverageBigDecimalSubscriber<T>(actual, this.mapping));
    }

    private static final class AverageBigDecimalSubscriber<T>
    extends MathSubscriber<T, BigDecimal> {
        private final Function<? super T, ? extends Number> mapping;
        private int count;
        private BigDecimal sum = BigDecimal.ZERO;

        AverageBigDecimalSubscriber(CoreSubscriber<? super BigDecimal> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void reset() {
            this.count = 0;
            this.sum = BigDecimal.ZERO;
        }

        @Override
        protected BigDecimal result() {
            return this.count == 0 ? null : this.sum.divide(BigDecimal.valueOf(this.count));
        }

        @Override
        protected void updateResult(T newValue) {
            Number number = this.mapping.apply(newValue);
            BigDecimal bigDecimalValue = BigDecimal.valueOf(number.doubleValue());
            this.sum = this.sum.add(bigDecimalValue);
            ++this.count;
        }
    }
}

