/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.websphere;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.CodeSource;
import org.springframework.util.FileCopyUtils;

class WebSphereClassPreDefinePlugin
implements InvocationHandler {
    private final ClassFileTransformer transformer;

    public WebSphereClassPreDefinePlugin(ClassFileTransformer transformer) {
        this.transformer = transformer;
        ClassLoader classLoader = transformer.getClass().getClassLoader();
        try {
            String dummyClass = Dummy.class.getName().replace('.', '/');
            byte[] bytes = FileCopyUtils.copyToByteArray(classLoader.getResourceAsStream(dummyClass + ".class"));
            transformer.transform(classLoader, dummyClass, null, null, bytes);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Cannot load transformer", ex);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
        String name = method2.getName();
        if ("equals".equals(name)) {
            return proxy == args[0];
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        if ("toString".equals(name)) {
            return this.toString();
        }
        if ("transformClass".equals(name)) {
            return this.transform((String)args[0], (byte[])args[1], (CodeSource)args[2], (ClassLoader)args[3]);
        }
        throw new IllegalArgumentException("Unknown method: " + method2);
    }

    protected byte[] transform(String className, byte[] classfileBuffer, CodeSource codeSource, ClassLoader classLoader) throws Exception {
        byte[] result = this.transformer.transform(classLoader, className.replace('.', '/'), null, null, classfileBuffer);
        return result != null ? result : classfileBuffer;
    }

    public String toString() {
        return this.getClass().getName() + " for transformer: " + this.transformer;
    }

    private static class Dummy {
        private Dummy() {
        }
    }
}

