/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.jetlinks.simulator.core.network.Address;
import org.jetlinks.simulator.core.network.AddressManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class DefaultAddressManager
implements AddressManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAddressManager.class);
    static DefaultAddressManager global = new DefaultAddressManager();
    private static final List<InetAddressRef> addressRefs = new ArrayList<InetAddressRef>();

    DefaultAddressManager() {
    }

    @Override
    public Address takeAddress() {
        for (InetAddressRef addressRef : addressRefs) {
            if (!addressRef.isAlive()) continue;
            return new AddressInfo(addressRef);
        }
        throw new IllegalStateException("Too many open ports!");
    }

    @Override
    public Address takeAddress(String networkInterface) {
        if (networkInterface == null) {
            return this.takeAddress();
        }
        for (InetAddressRef addressRef : addressRefs) {
            if (!networkInterface.equals(addressRef.getNetworkInterface().getName()) && !networkInterface.equals(addressRef.getNetworkInterface().getDisplayName()) && !networkInterface.equals(addressRef.getAddress().getHostAddress())) continue;
            if (addressRef.isAlive()) {
                return new AddressInfo(addressRef);
            }
            throw new IllegalStateException("Too many open ports!");
        }
        throw new IllegalStateException("Unknown network interface:" + networkInterface);
    }

    @Override
    public List<InetAddress> getAliveLocalAddresses() {
        return addressRefs.stream().filter(InetAddressRef::isAlive).map(InetAddressRef::getAddress).collect(Collectors.toList());
    }

    static {
        try {
            int maxPorts = Integer.getInteger("simulator.max-ports", 50000);
            String networkInterfaces = System.getProperty("simulator.network-interfaces", ".*");
            Enumeration<NetworkInterface> inf = NetworkInterface.getNetworkInterfaces();
            block2: while (inf.hasMoreElements()) {
                NetworkInterface it = inf.nextElement();
                if (StringUtils.hasText(networkInterfaces) && !it.getName().matches(networkInterfaces)) continue;
                Enumeration<InetAddress> addr = it.getInetAddresses();
                while (addr.hasMoreElements()) {
                    InetAddress address = addr.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    addressRefs.add(new InetAddressRef(it, address, maxPorts));
                    continue block2;
                }
            }
            log.debug("load network interfaces: {}", (Object)addressRefs);
        }
        catch (SocketException e) {
            log.error("load network interfaces error loaded: {}", (Object)addressRefs, (Object)e);
        }
    }

    private static class InetAddressRef
    extends AbstractReferenceCounted {
        private final NetworkInterface networkInterface;
        private final InetAddress address;

        public InetAddressRef(NetworkInterface networkInterface, InetAddress address, int count) {
            this.networkInterface = networkInterface;
            this.address = address;
            this.retain(count);
        }

        boolean isAlive() {
            return this.refCnt() > 1;
        }

        @Override
        public ReferenceCounted touch(Object hint) {
            return this;
        }

        @Override
        protected void deallocate() {
            throw new IllegalStateException(this.address + " Too many open ports!");
        }

        public String toString() {
            return this.address + "(" + this.refCnt() + ")";
        }

        public NetworkInterface getNetworkInterface() {
            return this.networkInterface;
        }

        public InetAddressRef(NetworkInterface networkInterface, InetAddress address) {
            this.networkInterface = networkInterface;
            this.address = address;
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }

    protected static class AddressInfo
    implements Address {
        private final InetAddressRef ref;
        private boolean released;

        protected AddressInfo(InetAddressRef ref) {
            this.ref = ref;
            this.ref.release();
        }

        @Override
        public InetAddress getAddress() {
            return this.ref.address;
        }

        @Override
        public synchronized void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            this.ref.retain();
        }
    }
}

