/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.benchmark;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.simulator.core.benchmark.Benchmark;
import org.joda.time.DateTime;

public interface BenchmarkHelper {
    public Object require(String var1);

    default public ByteBuf newBuffer() {
        return Unpooled.buffer();
    }

    default public String formatDate(Object time, String format) {
        return new DateTime(CastUtils.castDate(time)).toString(format);
    }

    default public long now() {
        return System.currentTimeMillis();
    }

    default public String now(String format) {
        return this.formatDate(this.now(), format);
    }

    default public String toJson(Object obj) {
        return JSON.toJSONString(Benchmark.scriptFactory.convertToJavaType(obj));
    }

    default public Object parseJson(Object obj) {
        if ((obj = Benchmark.scriptFactory.convertToJavaType(obj)) instanceof Buffer) {
            obj = ((Buffer)obj).toString(StandardCharsets.UTF_8);
        } else if (obj instanceof ByteBuf) {
            obj = ((ByteBuf)obj).toString(StandardCharsets.UTF_8);
        } else if (obj instanceof String) {
            return JSON.parseObject(String.valueOf(obj));
        }
        return obj;
    }

    default public Object toJavaType(Object obj) {
        return Benchmark.scriptFactory.convertToJavaType(obj);
    }

    default public String md5(Object obj) {
        return DigestUtils.md5Hex(String.valueOf(Benchmark.scriptFactory.convertToJavaType(obj)));
    }

    default public float randomFloat(float from, float to) {
        return (float)ThreadLocalRandom.current().nextDouble(from, to);
    }

    default public int randomInt(int from, int to) {
        return ThreadLocalRandom.current().nextInt(from, to);
    }
}

