/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.tcp;

import java.time.Duration;
import java.util.Iterator;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.tcp.TcpClient;
import picocli.CommandLine;

@CommandLine.Command(name="send", description={"Send TCP Packet"})
public class TcpSendCommand
extends AbstractCommand
implements Runnable {
    @CommandLine.Option(names={"--id"}, required=true, description={"ID"}, completionCandidates=IdComplete.class)
    String id;
    @CommandLine.Parameters(arity="1", description={"e.g. HEX format: 0x0F"})
    String payload;

    @Override
    public void run() {
        Connection connection = this.main().connectionManager().getConnection(this.id).blockOptional().orElse(null);
        if (connection == null) {
            this.printfError("\u8bf7\u5148\u4f7f\u7528\u547d\u4ee4\u521b\u5efatcp\u8fde\u63a5: tcp connect --id=%s %n", this.id);
            return;
        }
        TcpClient client = connection.unwrap(TcpClient.class);
        this.printf("sending %s ", this.payload);
        try {
            client.sendAsync(this.payload).block(Duration.ofSeconds(10L));
            this.printf("success!%n", new Object[0]);
        }
        catch (Throwable e) {
            this.printfError("error:%s%n", ExceptionUtils.getErrorMessage(e));
        }
    }

    static class IdComplete
    implements Iterable<String> {
        IdComplete() {
        }

        @Override
        public Iterator<String> iterator() {
            return ConnectionManager.global().getConnections().filter(c -> c.getType() == NetworkType.tcp_client).map(Connection::getId).collectList().block().iterator();
        }
    }
}

