/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.mqtt;

import java.time.Duration;
import java.util.Iterator;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.mqtt.MqttClient;
import picocli.CommandLine;

@CommandLine.Command(name="publish", description={"Publish mqtt message"})
public class MqttPublishCommand
extends AbstractCommand
implements Runnable {
    String clientId;
    @CommandLine.Option(names={"-t", "--topic"}, required=true, description={"mqtt topic"})
    String topic;
    @CommandLine.Option(names={"-q", "--qos"}, description={"QoS Level"}, defaultValue="0")
    int qos;
    @CommandLine.Parameters(arity="1", description={"0x\u5f00\u5934\u4e3a16\u8fdb\u5236"})
    String payload;

    @CommandLine.Option(names={"-c", "--clientId"}, required=true, description={"clientId"}, completionCandidates=IdComplete.class)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void run() {
        Connection connection = this.main().connectionManager().getConnection(this.clientId).blockOptional().orElse(null);
        if (connection == null) {
            this.printfError("\u8bf7\u5148\u4f7f\u7528\u547d\u4ee4\u521b\u5efamqtt\u8fde\u63a5: mqtt connect -c=%s %n", this.clientId);
            return;
        }
        MqttClient client = connection.unwrap(MqttClient.class);
        this.printf("publishing %s %s ", this.topic, this.payload);
        try {
            client.publishAsync(this.topic, this.qos, this.payload).block(Duration.ofSeconds(10L));
            this.printf("success!%n", new Object[0]);
        }
        catch (Throwable e) {
            this.printfError("error:%s%n", ExceptionUtils.getErrorMessage(e));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    static class IdComplete
    implements Iterable<String> {
        IdComplete() {
        }

        @Override
        public Iterator<String> iterator() {
            return ConnectionManager.global().getConnections().filter(c -> c.getType() == NetworkType.mqtt_client).map(Connection::getId).collectList().block().iterator();
        }
    }
}

