/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import picocli.CommandLine;

public class MultiParameterException
extends CommandLine.ParameterException {
    private static final long serialVersionUID = 1L;
    private List<CommandLine.Model.ArgSpec> argSpecs;

    public MultiParameterException(CommandLine commandLine, String msg, String ... optionNames) {
        this(commandLine, msg, MultiParameterException.namesToSpecs(commandLine, optionNames));
    }

    public MultiParameterException(CommandLine commandLine, String msg, CommandLine.Model.ArgSpec ... argsInError) {
        this(commandLine, msg, Arrays.asList(argsInError));
    }

    public MultiParameterException(CommandLine commandLine, String msg, List<CommandLine.Model.ArgSpec> argsInError) {
        this(commandLine, msg, argsInError, null);
    }

    public MultiParameterException(CommandLine commandLine, String msg, Throwable cause, String ... optionNames) {
        this(commandLine, msg, MultiParameterException.namesToSpecs(commandLine, optionNames), cause);
    }

    public MultiParameterException(CommandLine commandLine, String msg, List<CommandLine.Model.ArgSpec> argsInError, Throwable cause) {
        super(commandLine, msg, cause);
        this.argSpecs = argsInError;
    }

    public List<CommandLine.Model.ArgSpec> getArgSpecs() {
        return this.argSpecs;
    }

    private static List<CommandLine.Model.ArgSpec> namesToSpecs(CommandLine commandLine, String ... optionNames) {
        ArrayList<CommandLine.Model.ArgSpec> optionSpecs = new ArrayList<CommandLine.Model.ArgSpec>(optionNames.length);
        for (String optionName : optionNames) {
            CommandLine.Model.OptionSpec optionSpec = commandLine.getCommandSpec().findOption(optionName);
            if (optionSpec == null) {
                throw new IllegalArgumentException(String.format("Option [%s] does not exist for %s", optionName, commandLine.getCommandName()));
            }
            optionSpecs.add(optionSpec);
        }
        return optionSpecs;
    }
}

