/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.jetlinks.reactor.ql.utils.ExpressionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class CoalesceMapFeature
implements ValueMapFeature {
    private final String id = FeatureId.ValueMap.of("coalesce").getId();

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        List<Expression> parameters = ExpressionUtils.getFunctionParameter(function);
        if (CollectionUtils.isEmpty(parameters)) {
            throw new UnsupportedOperationException("\u51fd\u6570[" + expression + "]\u5fc5\u987b\u4f20\u5165\u53c2\u6570");
        }
        List mappers = parameters.stream().map(expr -> ValueMapFeature.createMapperNow(expr, metadata)).collect(Collectors.toList());
        return v -> {
            Flux flux = null;
            for (Function mapper : mappers) {
                Flux that = Flux.from((Publisher)mapper.apply(v));
                if (flux == null) {
                    flux = that;
                    continue;
                }
                flux = flux.switchIfEmpty(that);
            }
            return flux == null ? Flux.empty() : flux;
        };
    }

    @Override
    public String getId() {
        return this.id;
    }
}

