/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Set;
import org.jetlinks.core.utils.CompositeCollection;

public class CompositeSet<E>
extends CompositeCollection<E>
implements Set<E> {
    public CompositeSet(Set<E> first, Set<E> second) {
        super(first.size() >= second.size() ? first : second, second.size() > first.size() ? first : second);
    }

    @Override
    public int size() {
        int duplicate = 0;
        for (Object e : this.second) {
            if (!this.first.contains(e)) continue;
            ++duplicate;
        }
        return super.size() - duplicate;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorView();
    }

    class IteratorView
    extends AbstractIterator<E> {
        private final Iterator<E> firstIt;
        private final Iterator<E> secondIt;

        IteratorView() {
            this.firstIt = CompositeSet.this.first.iterator();
            this.secondIt = CompositeSet.this.second.iterator();
        }

        @Override
        protected E computeNext() {
            if (this.secondIt.hasNext()) {
                return this.secondIt.next();
            }
            while (this.firstIt.hasNext()) {
                Object e = this.firstIt.next();
                if (CompositeSet.this.second.contains(e)) continue;
                return e;
            }
            return this.endOfData();
        }
    }
}

