/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace.data;

import com.google.common.collect.Maps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.utils.SerializeUtils;

public class SpanEventDataInfo
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private String name;
    private long timeNanos;
    private Map<String, Object> attributes;

    public static SpanEventDataInfo of(EventData eventData) {
        return new SpanEventDataInfo().with(eventData);
    }

    public <T> Optional<T> getAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.get(key));
    }

    public <T> Optional<T> getAttribute(AttributeKey<T> key) {
        return this.getAttribute(key.getKey());
    }

    public SpanEventDataInfo with(EventData eventData) {
        this.name = eventData.getName();
        this.timeNanos = eventData.getEpochNanos();
        Attributes attr = eventData.getAttributes();
        if (!attr.isEmpty()) {
            this.attributes = Maps.newHashMapWithExpectedSize(attr.size());
            attr.forEach((k, v) -> this.attributes.put(k.getKey(), v));
        }
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.timeNanos);
        SerializeUtils.writeKeyValue(this.attributes, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.timeNanos = in.readLong();
        this.attributes = SerializeUtils.readMap(in, Maps::newHashMapWithExpectedSize);
    }

    public String getName() {
        return this.name;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTimeNanos(long timeNanos) {
        this.timeNanos = timeNanos;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

