/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.context;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.codec.context.CodecContext;

class CacheCodecContext
implements CodecContext {
    private final Map<Object, Cache> caches = new ConcurrentHashMap<Object, Cache>();

    CacheCodecContext() {
    }

    void checkExpires() {
        for (Map.Entry<Object, Cache> entry : this.caches.entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            this.caches.remove(entry.getKey());
        }
    }

    @Override
    public void cacheDownstream(Object key, RepayableDeviceMessage<? extends DeviceMessageReply> message, Duration ttl) {
        this.caches.put(key, new Cache(System.currentTimeMillis(), ttl.toMillis(), message));
        if (this.caches.size() > 100) {
            this.checkExpires();
        }
    }

    @Override
    public <T extends RepayableDeviceMessage<? extends DeviceMessageReply>> Optional<T> getDownstream(Object key, boolean remove) {
        return Optional.ofNullable(remove ? this.caches.remove(key) : this.caches.get(key)).map(cache -> {
            if (cache.isAlive()) {
                return cache.getMessage();
            }
            this.caches.remove(key, cache);
            return null;
        });
    }

    static class Cache {
        long cacheTime;
        long ttl;
        RepayableDeviceMessage<? extends DeviceMessageReply> msg;

        boolean isAlive() {
            return !this.isExpired();
        }

        boolean isExpired() {
            return this.ttl > 0L && System.currentTimeMillis() - this.cacheTime >= this.ttl;
        }

        <T extends RepayableDeviceMessage<? extends DeviceMessageReply>> T getMessage() {
            return (T)this.msg;
        }

        public Cache(long cacheTime, long ttl, RepayableDeviceMessage<? extends DeviceMessageReply> msg) {
            this.cacheTime = cacheTime;
            this.ttl = ttl;
            this.msg = msg;
        }
    }
}

