/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device.session;

import org.jetlinks.core.server.session.DeviceSession;

public class DeviceSessionEvent {
    private long timestamp;
    private Type type;
    private DeviceSession session;
    private boolean clusterExists;

    public static DeviceSessionEvent of(Type type, DeviceSession session, boolean remoteExists) {
        return DeviceSessionEvent.of(System.currentTimeMillis(), type, session, remoteExists);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Type getType() {
        return this.type;
    }

    public DeviceSession getSession() {
        return this.session;
    }

    public boolean isClusterExists() {
        return this.clusterExists;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSession(DeviceSession session) {
        this.session = session;
    }

    public void setClusterExists(boolean clusterExists) {
        this.clusterExists = clusterExists;
    }

    private DeviceSessionEvent(long timestamp, Type type, DeviceSession session, boolean clusterExists) {
        this.timestamp = timestamp;
        this.type = type;
        this.session = session;
        this.clusterExists = clusterExists;
    }

    public static DeviceSessionEvent of(long timestamp, Type type, DeviceSession session, boolean clusterExists) {
        return new DeviceSessionEvent(timestamp, type, session, clusterExists);
    }

    public DeviceSessionEvent() {
    }

    public static enum Type {
        register,
        unregister;

    }
}

