/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.i18n;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.i18n.UnsupportedMessageSource;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.context.MessageSource;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

public final class LocaleUtils {
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final FastThreadLocal<Locale> CONTEXT_THREAD_LOCAL = new FastThreadLocal();
    static MessageSource messageSource = UnsupportedMessageSource.instance();

    public static Locale current() {
        Locale locale = CONTEXT_THREAD_LOCAL.get();
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R doWith(T data, Locale locale, BiFunction<T, Locale, R> mapper) {
        Locale old = CONTEXT_THREAD_LOCAL.get();
        try {
            CONTEXT_THREAD_LOCAL.set(locale);
            R r = mapper.apply(data, locale);
            return r;
        }
        finally {
            CONTEXT_THREAD_LOCAL.set(old);
        }
    }

    public static void doWith(Locale locale, Consumer<Locale> consumer) {
        Locale old = CONTEXT_THREAD_LOCAL.get();
        try {
            CONTEXT_THREAD_LOCAL.set(locale);
            consumer.accept(locale);
        }
        finally {
            CONTEXT_THREAD_LOCAL.set(old);
        }
    }

    public static Function<Context, Context> useLocale(Locale locale) {
        return ctx -> ctx.put(Locale.class, locale);
    }

    public static Mono<Locale> currentReactive() {
        return Mono.subscriberContext().map(ctx -> ctx.getOrDefault(Locale.class, DEFAULT_LOCALE));
    }

    public static <T> Mono<T> doInReactive(Callable<T> call) {
        return LocaleUtils.currentReactive().handle((locale, sink) -> {
            Locale old = CONTEXT_THREAD_LOCAL.get();
            try {
                CONTEXT_THREAD_LOCAL.set((Locale)locale);
                Object data = call.call();
                if (data != null) {
                    sink.next(data);
                }
            }
            catch (Throwable e) {
                sink.error(e);
            }
            finally {
                CONTEXT_THREAD_LOCAL.set(old);
            }
        });
    }

    public static <S extends I18nSupportException, R> Mono<R> resolveThrowable(S source, BiFunction<S, String, R> mapper) {
        return LocaleUtils.resolveThrowable(messageSource, source, mapper);
    }

    public static <S extends I18nSupportException, R> Mono<R> resolveThrowable(MessageSource messageSource, S source, BiFunction<S, String, R> mapper) {
        return LocaleUtils.doWithReactive(messageSource, source, I18nSupportException::getI18nCode, mapper, source.getArgs());
    }

    public static <S extends Throwable, R> Mono<R> resolveThrowable(S source, BiFunction<S, String, R> mapper, Object ... args) {
        return LocaleUtils.resolveThrowable(messageSource, source, mapper, args);
    }

    public static <S extends Throwable, R> Mono<R> resolveThrowable(MessageSource messageSource, S source, BiFunction<S, String, R> mapper, Object ... args) {
        if (source instanceof I18nSupportException && args.length == 0) {
            I18nSupportException ex = (I18nSupportException)source;
            return LocaleUtils.resolveThrowable(ex, (err, msg) -> mapper.apply(source, (String)msg));
        }
        return LocaleUtils.doWithReactive(messageSource, source, Throwable::getMessage, mapper, args);
    }

    public static <S, R> Mono<R> doWithReactive(S source, Function<S, String> message, BiFunction<S, String, R> mapper, Object ... args) {
        return LocaleUtils.doWithReactive(messageSource, source, message, mapper, args);
    }

    public static <S, R> Mono<R> doWithReactive(MessageSource messageSource, S source, Function<S, String> message, BiFunction<S, String, R> mapper, Object ... args) {
        return LocaleUtils.currentReactive().map(locale -> {
            String msg = (String)message.apply(source);
            String newMsg = LocaleUtils.resolveMessage(messageSource, locale, msg, msg, args);
            return mapper.apply(source, newMsg);
        });
    }

    public static Mono<String> resolveMessageReactive(String code, Object ... args) {
        return LocaleUtils.currentReactive().map(locale -> LocaleUtils.resolveMessage(messageSource, locale, code, code, args));
    }

    public static Mono<String> resolveMessageReactive(MessageSource messageSource, String code, Object ... args) {
        return LocaleUtils.currentReactive().map(locale -> LocaleUtils.resolveMessage(messageSource, locale, code, code, args));
    }

    public static String resolveMessage(String code, Locale locale, String defaultMessage, Object ... args) {
        return LocaleUtils.resolveMessage(messageSource, locale, code, defaultMessage, args);
    }

    public static String resolveMessage(MessageSource messageSource, Locale locale, String code, String defaultMessage, Object ... args) {
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public static String resolveMessage(String code, Object ... args) {
        return LocaleUtils.resolveMessage(messageSource, LocaleUtils.current(), code, code, args);
    }

    public static String resolveMessage(String code, String defaultMessage, Object ... args) {
        return LocaleUtils.resolveMessage(messageSource, LocaleUtils.current(), code, defaultMessage, args);
    }

    public static String resolveMessage(MessageSource messageSource, String code, String defaultMessage, Object ... args) {
        return LocaleUtils.resolveMessage(messageSource, LocaleUtils.current(), code, defaultMessage, args);
    }

    public static <T> Consumer<Signal<T>> on(SignalType type, BiConsumer<Signal<T>, Locale> operation) {
        return signal -> {
            if (signal.getType() != type) {
                return;
            }
            Locale locale = signal.getContext().getOrDefault(Locale.class, DEFAULT_LOCALE);
            LocaleUtils.doWith(locale, l -> operation.accept((Signal)signal, (Locale)l));
        };
    }

    public static <E, T extends Publisher<E>> Function<T, T> doOn(SignalType type, BiConsumer<Signal<E>, Locale> operation) {
        return publisher -> {
            if (publisher instanceof Mono) {
                return Mono.from(publisher).doOnEach(LocaleUtils.on(type, operation));
            }
            return Flux.from(publisher).doOnEach(LocaleUtils.on(type, operation));
        };
    }

    public static <E, T extends Publisher<E>> Function<T, T> doOnNext(Consumer<E> operation) {
        return LocaleUtils.doOn(SignalType.ON_NEXT, (s2, l) -> operation.accept(s2.get()));
    }

    public static <E, T extends Publisher<E>> Function<T, T> doOnNext(BiConsumer<E, Locale> operation) {
        return LocaleUtils.doOn(SignalType.ON_NEXT, (s2, l) -> operation.accept((Object)s2.get(), (Locale)l));
    }

    public static <E, T extends Publisher<E>> Function<T, T> doOnError(Consumer<Throwable> operation) {
        return LocaleUtils.doOn(SignalType.ON_ERROR, (s2, l) -> operation.accept(s2.getThrowable()));
    }

    public static <E, T extends Publisher<E>> Function<T, T> doOnError(BiConsumer<Throwable, Locale> operation) {
        return LocaleUtils.doOn(SignalType.ON_ERROR, (s2, l) -> operation.accept(s2.getThrowable(), (Locale)l));
    }

    public static <T> Flux<T> transform(Flux<T> flux) {
        return new LocaleFlux<T>(flux);
    }

    public static <T> Mono<T> transform(Mono<T> mono) {
        return new LocaleMono<T>(mono);
    }

    static class LocaleSwitchSubscriber<T>
    extends BaseSubscriber<T> {
        private final CoreSubscriber<T> actual;

        @Override
        @Nonnull
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        protected void hookOnSubscribe(@Nonnull Subscription subscription) {
            this.actual.onSubscribe(this);
        }

        private Locale current() {
            return this.currentContext().getOrDefault(Locale.class, DEFAULT_LOCALE);
        }

        @Override
        protected void hookOnComplete() {
            LocaleUtils.doWith(this.current(), l -> this.actual.onComplete());
        }

        @Override
        protected void hookOnError(@Nonnull Throwable error) {
            LocaleUtils.doWith(error, this.current(), (v, l) -> {
                this.actual.onError((Throwable)v);
                return null;
            });
        }

        @Override
        protected void hookOnNext(@Nonnull T value) {
            LocaleUtils.doWith(value, this.current(), (v, l) -> {
                this.actual.onNext(v);
                return null;
            });
        }

        public LocaleSwitchSubscriber(CoreSubscriber<T> actual) {
            this.actual = actual;
        }
    }

    static class LocaleFlux<T>
    extends Flux<T> {
        private final Flux<T> source;

        @Override
        public void subscribe(@Nonnull CoreSubscriber<? super T> actual) {
            LocaleUtils.doWith(actual, actual.currentContext().getOrDefault(Locale.class, DEFAULT_LOCALE), (a, l) -> {
                this.source.subscribe(new LocaleSwitchSubscriber(a));
                return null;
            });
        }

        public LocaleFlux(Flux<T> source) {
            this.source = source;
        }
    }

    static class LocaleMono<T>
    extends Mono<T> {
        private final Mono<T> source;

        @Override
        public void subscribe(@Nonnull CoreSubscriber<? super T> actual) {
            LocaleUtils.doWith(actual, actual.currentContext().getOrDefault(Locale.class, DEFAULT_LOCALE), (a, l) -> {
                this.source.subscribe(new LocaleSwitchSubscriber(a));
                return null;
            });
        }

        public LocaleMono(Mono<T> source) {
            this.source = source;
        }
    }
}

