/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.script.engine.ognl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.ExecuteResult;
import org.hswebframework.expands.script.engine.ListenerSupportEngine;
import org.hswebframework.expands.script.engine.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlEngine
extends ListenerSupportEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, OgnlScriptContext> cache = new ConcurrentHashMap<String, OgnlScriptContext>();

    @Override
    public boolean compiled(String id) {
        return this.cache.containsKey(id);
    }

    @Override
    public ScriptContext getContext(String id) {
        return this.cache.get(id);
    }

    @Override
    public boolean remove(String id) {
        return this.cache.remove(id) != null;
    }

    @Override
    public void init(String ... contents) throws Exception {
    }

    @Override
    public ExecuteResult execute(String id) {
        return this.execute(id, new HashMap<String, Object>());
    }

    @Override
    public boolean compile(String id, String code) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("compile Ognl {} : {}", (Object)id, (Object)code);
        }
        this.cache.put(id, new OgnlScriptContext(id, DigestUtils.md5Hex(code), Ognl.parseExpression((String)code)));
        return false;
    }

    @Override
    public ExecuteResult execute(String id, Map<String, Object> param) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute Ognl {} : {}", (Object)id, (Object)param);
        }
        ExecuteResult result = new ExecuteResult();
        long start = System.currentTimeMillis();
        OgnlScriptContext scriptContext = this.cache.get(id);
        try {
            if (scriptContext != null) {
                this.doListenerBefore(scriptContext);
                scriptContext = this.cache.get(id);
                param = new HashMap<String, Object>(param);
                param.putAll(this.getGlobalVariable());
                Object obj = Ognl.getValue((Object)scriptContext.getScript(), param, param);
                result.setSuccess(true);
                result.setResult(obj);
            } else {
                result.setSuccess(false);
                result.setResult(null);
                result.setMessage(String.format("Ognl: %s not found!", id));
            }
            long end = System.currentTimeMillis();
            result.setUseTime(end - start);
        }
        catch (Exception e) {
            this.logger.error("execute SpEL error", e);
            result.setException(e);
        }
        this.doListenerAfter(scriptContext, result);
        return result;
    }

    class OgnlScriptContext
    extends ScriptContext {
        private Object script;

        public OgnlScriptContext(String id, String md5, Object script) {
            super(id, md5);
            this.script = script;
        }

        public Object getScript() {
            return this.script;
        }
    }
}

